/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.bval.BeanValidationContext;
import org.apache.bval.MetaBeanFinder;
import org.apache.bval.MetaBeanManagerFactory;
import org.apache.bval.Validate;
import org.apache.bval.ValidationResults;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaProperty;
import org.apache.bval.model.ValidationContext;
import org.apache.bval.model.ValidationListener;
import org.apache.bval.util.AccessStrategy;
import org.apache.bval.util.PropertyAccess;
import org.apache.bval.util.ValidationHelper;

public class BeanValidator<T extends ValidationListener> {
    private final MetaBeanFinder metaBeanFinder;
    private boolean treatMapsLikeBeans = false;

    public BeanValidator() {
        this(MetaBeanManagerFactory.getFinder());
    }

    public BeanValidator(MetaBeanFinder metaBeanFinder) {
        this.metaBeanFinder = metaBeanFinder;
    }

    public T validate(Object bean) {
        MetaBean metaBean = this.getMetaBeanFinder().findForClass(bean.getClass());
        return this.validate(bean, metaBean);
    }

    public T validate(Object bean, MetaBean metaBean) {
        ValidationContext<T> context = this.createContext();
        context.setBean(bean, metaBean);
        ValidationHelper.validateContext(context, new BeanValidatorCallback(context), this.treatMapsLikeBeans);
        return context.getListener();
    }

    public T validateCall(Method method, Object[] parameters) {
        if (parameters.length > 0) {
            Annotation[][] annotations = method.getParameterAnnotations();
            ValidationContext<T> context = null;
            block0: for (int i = 0; i < parameters.length; ++i) {
                for (Annotation anno : annotations[i]) {
                    if (!(anno instanceof Validate)) continue;
                    if (context == null) {
                        context = this.createContext();
                    }
                    if (!this.determineMetaBean((Validate)anno, parameters[i], context)) continue;
                    ValidationHelper.validateContext(context, new BeanValidatorCallback(context), this.treatMapsLikeBeans);
                    continue block0;
                }
            }
            return context == null ? null : (T)context.getListener();
        }
        return null;
    }

    protected <VL extends ValidationListener> boolean determineMetaBean(Validate validate, Object parameter, ValidationContext<VL> context) {
        if (validate.value().isEmpty()) {
            Class<?> beanClass;
            if (parameter == null) {
                return false;
            }
            if (parameter instanceof Collection) {
                Collection coll = (Collection)parameter;
                if (coll.isEmpty()) {
                    return false;
                }
                beanClass = coll.iterator().next().getClass();
            } else {
                beanClass = parameter.getClass().isArray() ? parameter.getClass().getComponentType() : parameter.getClass();
            }
            context.setBean(parameter, this.getMetaBeanFinder().findForClass(beanClass));
        } else {
            context.setBean(parameter, this.getMetaBeanFinder().findForId(validate.value()));
        }
        return true;
    }

    protected T createResults() {
        return (T)new ValidationResults();
    }

    protected ValidationContext<T> createContext() {
        return new BeanValidationContext<T>(this.createResults());
    }

    public T validateProperty(Object bean, MetaProperty metaProperty) {
        ValidationContext<T> context = this.createContext();
        context.setBean(bean);
        context.setMetaProperty(metaProperty);
        ValidationHelper.validateProperty(context);
        return context.getListener();
    }

    protected <VL extends ValidationListener> void validateBeanNet(ValidationContext<VL> context) {
        if (context.collectValidated()) {
            ValidationHelper.validateBean(context);
            for (MetaProperty prop : context.getMetaBean().getProperties()) {
                this.validateRelatedBean(context, prop);
            }
        }
    }

    protected <VL extends ValidationListener> void validateRelatedBean(ValidationContext<VL> context, MetaProperty prop) {
        AccessStrategy[] access = (AccessStrategy[])prop.getFeature("refCascade");
        if (access == null && prop.getMetaBean() != null) {
            Object bean = context.getBean();
            MetaBean mbean = context.getMetaBean();
            context.moveDown(prop, new PropertyAccess(bean.getClass(), prop.getName()));
            ValidationHelper.validateContext(context, new BeanValidatorCallback(context), this.treatMapsLikeBeans);
            context.moveUp(bean, mbean);
        } else if (access != null) {
            Object bean = context.getBean();
            MetaBean mbean = context.getMetaBean();
            for (AccessStrategy each : access) {
                context.moveDown(prop, each);
                ValidationHelper.validateContext(context, new BeanValidatorCallback(context), this.treatMapsLikeBeans);
                context.moveUp(bean, mbean);
            }
        }
    }

    public boolean isTreatMapsLikeBeans() {
        return this.treatMapsLikeBeans;
    }

    public void setTreatMapsLikeBeans(boolean treatMapsLikeBeans) {
        this.treatMapsLikeBeans = treatMapsLikeBeans;
    }

    public MetaBeanFinder getMetaBeanFinder() {
        return this.metaBeanFinder;
    }

    private class BeanValidatorCallback
    implements ValidationHelper.ValidateCallback {
        private final ValidationContext<?> context;

        public BeanValidatorCallback(ValidationContext<?> context) {
            this.context = context;
        }

        @Override
        public void validate() {
            BeanValidator.this.validateBeanNet(this.context);
        }
    }
}

