/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.compress.utils.Lists;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.datastream.impl.stream.AbstractDataStream;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;
import org.apache.flink.util.Preconditions;

@Internal
public class DataStreamV2SinkTransformation<InputT, OutputT>
extends PhysicalTransformation<OutputT> {
    private final AbstractDataStream<InputT> inputStream;
    private final Sink<InputT> sink;
    private final Transformation<InputT> input;
    private ChainingStrategy chainingStrategy;

    public DataStreamV2SinkTransformation(AbstractDataStream<InputT> inputStream, Sink<InputT> sink, TypeInformation<OutputT> outputType, String name, int parallelism, boolean parallelismConfigured) {
        super(name, outputType, parallelism, parallelismConfigured);
        this.inputStream = (AbstractDataStream)Preconditions.checkNotNull(inputStream);
        this.sink = (Sink)Preconditions.checkNotNull(sink);
        this.input = inputStream.getTransformation();
    }

    public void setChainingStrategy(ChainingStrategy strategy) {
        this.chainingStrategy = (ChainingStrategy)Preconditions.checkNotNull((Object)strategy);
    }

    protected List<Transformation<?>> getTransitivePredecessorsInternal() {
        ArrayList result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input.getTransitivePredecessors());
        return result;
    }

    public List<Transformation<?>> getInputs() {
        return Collections.singletonList(this.input);
    }

    @Nullable
    public ChainingStrategy getChainingStrategy() {
        return this.chainingStrategy;
    }

    public AbstractDataStream<InputT> getInputStream() {
        return this.inputStream;
    }

    public Sink<InputT> getSink() {
        return this.sink;
    }
}

