/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.util.ExceptionUtils;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class PipelineErrorHandler
extends SimpleChannelInboundHandler<Object> {
    private final Logger logger;

    public PipelineErrorHandler(Logger logger) {
        this.logger = logger;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object message) {
        this.logger.debug("Unknown message received: {}", message);
        this.sendError(ctx, "Unknown message received.");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.logger.debug("Unhandled exception.", cause);
        this.sendError(ctx, ExceptionUtils.stringifyException((Throwable)cause));
    }

    private void sendError(ChannelHandlerContext ctx, String error) {
        if (ctx.channel().isActive()) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.wrappedBuffer((byte[])error.getBytes(ConfigConstants.DEFAULT_CHARSET)));
            response.headers().set("Content-Type", (Object)"text/plain");
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
            ctx.writeAndFlush((Object)response);
        }
    }
}

