/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import org.apache.flink.metrics.AbstractHistogramTest;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.runtime.metrics.DescriptiveStatisticsHistogram;
import org.apache.flink.runtime.metrics.DescriptiveStatisticsHistogramStatistics;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.function.FunctionWithException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DescriptiveStatisticsHistogramTest
extends AbstractHistogramTest {
    private static final double[] DATA = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};

    @Test
    public void testDescriptiveHistogram() {
        int size = 10;
        this.testHistogram(size, (Histogram)new DescriptiveStatisticsHistogram(size));
    }

    @Test
    public void testSerialization() throws Exception {
        DescriptiveStatisticsHistogramTest.testDuplication((FunctionWithException<DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot, DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot, Exception>)((FunctionWithException)original -> {
            byte[] bytes = InstantiationUtil.serializeObject((Object)original);
            return (DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot)InstantiationUtil.deserializeObject((byte[])bytes, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        }));
    }

    @Test
    public void testCopy() throws Exception {
        DescriptiveStatisticsHistogramTest.testDuplication((FunctionWithException<DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot, DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot, Exception>)((FunctionWithException)DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot::copy));
    }

    private static void testDuplication(FunctionWithException<DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot, DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot, Exception> duplicator) throws Exception {
        DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot original = new DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot();
        original.evaluate(DATA);
        DescriptiveStatisticsHistogramTest.assertOperations(original);
        DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot copy = (DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot)duplicator.apply((Object)original);
        DescriptiveStatisticsHistogramTest.assertOperations(copy);
    }

    private static void assertOperations(DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot statistics) {
        Assert.assertThat((Object)statistics.getPercentile(0.5), (Matcher)CoreMatchers.equalTo((Object)1.0));
        Assert.assertThat((Object)statistics.getCount(), (Matcher)CoreMatchers.equalTo((Object)9L));
        Assert.assertThat((Object)statistics.getMin(), (Matcher)CoreMatchers.equalTo((Object)1.0));
        Assert.assertThat((Object)statistics.getMax(), (Matcher)CoreMatchers.equalTo((Object)9.0));
        Assert.assertThat((Object)statistics.getMean(), (Matcher)CoreMatchers.equalTo((Object)5.0));
        Assert.assertThat((Object)statistics.getStandardDeviation(), (Matcher)Matchers.closeTo((double)2.7, (double)0.5));
        Assert.assertThat((Object)statistics.getValues(), (Matcher)CoreMatchers.equalTo((Object)DATA));
    }
}

