/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.plugin.TestingPluginManager;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.reporter.InstantiateViaFactory;
import org.apache.flink.metrics.reporter.InterceptInstantiationViaReflection;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.metrics.reporter.MetricReporterFactory;
import org.apache.flink.runtime.metrics.ReporterSetup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.util.TestReporter;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;

public class ReporterSetupTest
extends TestLogger {
    @Test
    public void testReporterArgumentForwarding() {
        Configuration config = new Configuration();
        ReporterSetupTest.configureReporter1(config);
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        ReporterSetup reporterSetup = (ReporterSetup)reporterSetups.get(0);
        ReporterSetupTest.assertReporter1Configured(reporterSetup);
    }

    @Test
    public void testSeveralReportersWithArgumentForwarding() {
        Configuration config = new Configuration();
        ReporterSetupTest.configureReporter1(config);
        ReporterSetupTest.configureReporter2(config);
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)2L, (long)reporterSetups.size());
        Optional<ReporterSetup> reporter1Config = reporterSetups.stream().filter(c -> "reporter1".equals(c.getName())).findFirst();
        Assert.assertTrue((boolean)reporter1Config.isPresent());
        ReporterSetupTest.assertReporter1Configured(reporter1Config.get());
        Optional<ReporterSetup> reporter2Config = reporterSetups.stream().filter(c -> "reporter2".equals(c.getName())).findFirst();
        Assert.assertTrue((boolean)reporter2Config.isPresent());
        ReporterSetupTest.assertReporter2Configured(reporter2Config.get());
    }

    @Test
    public void testActivateOneReporterAmongTwoDeclared() {
        Configuration config = new Configuration();
        ReporterSetupTest.configureReporter1(config);
        ReporterSetupTest.configureReporter2(config);
        config.setString(MetricOptions.REPORTERS_LIST, "reporter2");
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        ReporterSetup setup = (ReporterSetup)reporterSetups.get(0);
        ReporterSetupTest.assertReporter2Configured(setup);
    }

    @Test
    public void testReporterSetupSupplier() throws Exception {
        Configuration config = new Configuration();
        config.setString("metrics.reporter.reporter1.class", TestReporter1.class.getName());
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        ReporterSetup reporterSetup = (ReporterSetup)reporterSetups.get(0);
        MetricReporter metricReporter = reporterSetup.getReporter();
        Assert.assertThat((Object)metricReporter, (Matcher)IsInstanceOf.instanceOf(TestReporter1.class));
    }

    @Test
    public void testMultipleReporterInstantiation() throws Exception {
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test1.class", TestReporter11.class.getName());
        config.setString("metrics.reporter.test2.class", TestReporter12.class.getName());
        config.setString("metrics.reporter.test3.class", TestReporter13.class.getName());
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)3L, (long)reporterSetups.size());
        Assert.assertTrue((boolean)TestReporter11.wasOpened);
        Assert.assertTrue((boolean)TestReporter12.wasOpened);
        Assert.assertTrue((boolean)TestReporter13.wasOpened);
    }

    private static void configureReporter1(Configuration config) {
        config.setString("metrics.reporter.reporter1.class", TestReporter1.class.getName());
        config.setString("metrics.reporter.reporter1.arg1", "value1");
        config.setString("metrics.reporter.reporter1.arg2", "value2");
    }

    private static void assertReporter1Configured(ReporterSetup setup) {
        Assert.assertEquals((Object)"reporter1", (Object)setup.getName());
        Assert.assertEquals((Object)"value1", (Object)setup.getConfiguration().getString("arg1", ""));
        Assert.assertEquals((Object)"value2", (Object)setup.getConfiguration().getString("arg2", ""));
        Assert.assertEquals((Object)TestReporter1.class.getName(), (Object)setup.getConfiguration().getString("class", null));
    }

    private static void configureReporter2(Configuration config) {
        config.setString("metrics.reporter.reporter2.class", TestReporter2.class.getName());
        config.setString("metrics.reporter.reporter2.arg1", "value1");
        config.setString("metrics.reporter.reporter2.arg3", "value3");
    }

    private static void assertReporter2Configured(ReporterSetup setup) {
        Assert.assertEquals((Object)"reporter2", (Object)setup.getName());
        Assert.assertEquals((Object)"value1", (Object)setup.getConfiguration().getString("arg1", null));
        Assert.assertEquals((Object)"value3", (Object)setup.getConfiguration().getString("arg3", null));
        Assert.assertEquals((Object)TestReporter2.class.getName(), (Object)setup.getConfiguration().getString("class", null));
    }

    @Test
    public void testVariableExclusionParsing() throws Exception {
        String excludedVariable1 = "foo";
        String excludedVariable2 = "foo";
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test.factory.class", TestReporterFactory.class.getName());
        config.setString("metrics.reporter.test.scope.variables.excludes", "foo;foo");
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        ReporterSetup reporterSetup = (ReporterSetup)reporterSetups.get(0);
        MatcherAssert.assertThat((Object)reporterSetup.getExcludedVariables(), (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{ScopeFormat.asVariable((String)"foo"), ScopeFormat.asVariable((String)"foo")}));
    }

    @Test
    public void testFactoryParsing() throws Exception {
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test.factory.class", TestReporterFactory.class.getName());
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        ReporterSetup reporterSetup = (ReporterSetup)reporterSetups.get(0);
        Assert.assertEquals((Object)TestReporterFactory.REPORTER, (Object)reporterSetup.getReporter());
    }

    @Test
    public void testFactoryPrioritization() throws Exception {
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test.factory.class", InstantiationTypeTrackingTestReporterFactory.class.getName());
        config.setString("metrics.reporter.test.class", InstantiationTypeTrackingTestReporter.class.getName());
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        ReporterSetup reporterSetup = (ReporterSetup)reporterSetups.get(0);
        InstantiationTypeTrackingTestReporter metricReporter = (InstantiationTypeTrackingTestReporter)reporterSetup.getReporter();
        Assert.assertTrue((boolean)metricReporter.createdByFactory);
    }

    @Test
    public void testFactoryFailureIsolation() throws Exception {
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test.factory.class", TestReporterFactory.class.getName());
        config.setString("metrics.reporter.fail.factory.class", FailingFactory.class.getName());
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
    }

    @Test
    public void testMixedSetupsFactoryParsing() throws Exception {
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test1.factory.class", InstantiationTypeTrackingTestReporterFactory.class.getName());
        config.setString("metrics.reporter.test2.class", InstantiationTypeTrackingTestReporter.class.getName());
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)2L, (long)reporterSetups.size());
        ReporterSetup reporterSetup1 = (ReporterSetup)reporterSetups.get(0);
        ReporterSetup reporterSetup2 = (ReporterSetup)reporterSetups.get(1);
        InstantiationTypeTrackingTestReporter metricReporter1 = (InstantiationTypeTrackingTestReporter)reporterSetup1.getReporter();
        InstantiationTypeTrackingTestReporter metricReporter2 = (InstantiationTypeTrackingTestReporter)reporterSetup2.getReporter();
        Assert.assertTrue((boolean)(metricReporter1.createdByFactory ^ metricReporter2.createdByFactory));
    }

    @Test
    public void testFactoryArgumentForwarding() throws Exception {
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test.factory.class", ConfigExposingReporterFactory.class.getName());
        config.setString("metrics.reporter.test.arg", "hello");
        ReporterSetup.fromConfiguration((Configuration)config, null);
        Properties passedConfig = ConfigExposingReporterFactory.lastConfig;
        Assert.assertEquals((Object)"hello", (Object)passedConfig.getProperty("arg"));
    }

    @Test
    public void testFactoryAnnotation() {
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test.class", InstantiationTypeTrackingTestReporter2.class.getName());
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        ReporterSetup reporterSetup = (ReporterSetup)reporterSetups.get(0);
        InstantiationTypeTrackingTestReporter metricReporter = (InstantiationTypeTrackingTestReporter)reporterSetup.getReporter();
        Assert.assertTrue((boolean)metricReporter.createdByFactory);
    }

    @Test
    public void testReflectionInterception() {
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test.class", InstantiationTypeTrackingTestReporter.class.getName());
        List reporterSetups = ReporterSetup.fromConfiguration((Configuration)config, (PluginManager)new TestingPluginManager(Collections.singletonMap(MetricReporterFactory.class, Collections.singletonList(new InterceptingInstantiationTypeTrackingTestReporterFactory()).iterator())));
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        ReporterSetup reporterSetup = (ReporterSetup)reporterSetups.get(0);
        InstantiationTypeTrackingTestReporter metricReporter = (InstantiationTypeTrackingTestReporter)reporterSetup.getReporter();
        Assert.assertTrue((boolean)metricReporter.createdByFactory);
    }

    @InstantiateViaFactory(factoryClassName="org.apache.flink.runtime.metrics.ReporterSetupTest$InstantiationTypeTrackingTestReporterFactory")
    protected static class InstantiationTypeTrackingTestReporter2
    extends InstantiationTypeTrackingTestReporter {
        protected InstantiationTypeTrackingTestReporter2() {
        }
    }

    protected static class InstantiationTypeTrackingTestReporter
    extends TestReporter {
        private final boolean createdByFactory;

        public InstantiationTypeTrackingTestReporter() {
            this(false);
        }

        InstantiationTypeTrackingTestReporter(boolean createdByFactory) {
            this.createdByFactory = createdByFactory;
        }

        public boolean isCreatedByFactory() {
            return this.createdByFactory;
        }
    }

    @InterceptInstantiationViaReflection(reporterClassName="org.apache.flink.runtime.metrics.ReporterSetupTest$InstantiationTypeTrackingTestReporter")
    public static class InterceptingInstantiationTypeTrackingTestReporterFactory
    implements MetricReporterFactory {
        public MetricReporter createMetricReporter(Properties config) {
            return new InstantiationTypeTrackingTestReporter(true);
        }
    }

    public static class InstantiationTypeTrackingTestReporterFactory
    implements MetricReporterFactory {
        public MetricReporter createMetricReporter(Properties config) {
            return new InstantiationTypeTrackingTestReporter(true);
        }
    }

    public static class FailingFactory
    implements MetricReporterFactory {
        public MetricReporter createMetricReporter(Properties config) {
            throw new RuntimeException();
        }
    }

    public static class TestReporterFactory
    implements MetricReporterFactory {
        static final MetricReporter REPORTER = new TestReporter();

        public MetricReporter createMetricReporter(Properties config) {
            return REPORTER;
        }
    }

    public static class ConfigExposingReporterFactory
    implements MetricReporterFactory {
        static Properties lastConfig = null;

        public MetricReporter createMetricReporter(Properties config) {
            lastConfig = config;
            return new TestReporter();
        }
    }

    protected static class TestReporter13
    extends TestReporter {
        public static boolean wasOpened = false;

        protected TestReporter13() {
        }

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }

    protected static class TestReporter12
    extends TestReporter {
        public static boolean wasOpened = false;

        protected TestReporter12() {
        }

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }

    protected static class TestReporter11
    extends TestReporter {
        public static boolean wasOpened = false;

        protected TestReporter11() {
        }

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }

    static class TestReporter2
    extends TestReporter {
        TestReporter2() {
        }
    }

    static class TestReporter1
    extends TestReporter {
        TestReporter1() {
        }
    }
}

