/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.metrics.TimerGauge;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.ManualClock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TimerGaugeTest {
    private static final long SLEEP = 10L;

    @Test
    public void testBasicUsage() {
        ManualClock clock = new ManualClock(42000000L);
        TimerGauge gauge = new TimerGauge((Clock)clock);
        gauge.update();
        Assert.assertThat((Object)gauge.getValue(), (Matcher)Matchers.is((Object)0L));
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        gauge.update();
        Assert.assertThat((Object)gauge.getValue(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(2L)));
    }

    @Test
    public void testUpdateWithoutMarkingEnd() {
        ManualClock clock = new ManualClock(42000000L);
        TimerGauge gauge = new TimerGauge((Clock)clock);
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.update();
        Assert.assertThat((Object)gauge.getValue(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(2L)));
    }

    @Test
    public void testGetWithoutUpdate() {
        ManualClock clock = new ManualClock(42000000L);
        TimerGauge gauge = new TimerGauge((Clock)clock);
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)gauge.getValue(), (Matcher)Matchers.is((Object)0L));
        gauge.markEnd();
        Assert.assertThat((Object)gauge.getValue(), (Matcher)Matchers.is((Object)0L));
    }
}

