/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.slotmanager.AbstractFineGrainedSlotManagerITCase;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultResourceAllocationStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedSlotManagerTestBase;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceAllocationStrategy;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class FineGrainedSlotManagerDefaultResourceAllocationStrategyITCase
extends AbstractFineGrainedSlotManagerITCase {
    private static final ResourceProfile OTHER_SLOT_RESOURCE_PROFILE = DEFAULT_TOTAL_RESOURCE_PROFILE.multiply(2);

    @Override
    protected Optional<ResourceAllocationStrategy> getResourceAllocationStrategy() {
        return Optional.of(new DefaultResourceAllocationStrategy(DEFAULT_TOTAL_RESOURCE_PROFILE, 2));
    }

    @Test
    public void testWorkerOnlyAllocatedIfRequestedSlotCouldBeFulfilled() throws Exception {
        final AtomicInteger resourceRequests = new AtomicInteger(0);
        new FineGrainedSlotManagerTestBase.Context(){
            {
                super(FineGrainedSlotManagerDefaultResourceAllocationStrategyITCase.this);
                this.resourceActionsBuilder.setAllocateResourceFunction(ignored -> {
                    resourceRequests.incrementAndGet();
                    return true;
                });
                this.runTest(() -> {
                    this.runInMainThread(() -> this.getSlotManager().processResourceRequirements(FineGrainedSlotManagerTestBase.createResourceRequirements(new JobID(), 1, OTHER_SLOT_RESOURCE_PROFILE)));
                    Assert.assertThat((Object)resourceRequests.get(), (Matcher)Matchers.is((Object)0));
                });
            }
        };
    }
}

