/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import java.util.Collection;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.scheduler.adaptive.allocator.JobInformation;
import org.apache.flink.runtime.scheduler.adaptive.allocator.ReservedSlots;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotAllocator;
import org.apache.flink.runtime.scheduler.adaptive.allocator.VertexParallelism;
import org.apache.flink.runtime.util.ResourceCounter;

public class TestingSlotAllocator
implements SlotAllocator {
    private final Function<Iterable<JobInformation.VertexInformation>, ResourceCounter> calculateRequiredSlotsFunction;
    private final BiFunction<JobInformation, Collection<? extends SlotInfo>, Optional<? extends VertexParallelism>> determineParallelismFunction;
    private final Function<VertexParallelism, Optional<ReservedSlots>> tryReserveResourcesFunction;

    private TestingSlotAllocator(Function<Iterable<JobInformation.VertexInformation>, ResourceCounter> calculateRequiredSlotsFunction, BiFunction<JobInformation, Collection<? extends SlotInfo>, Optional<? extends VertexParallelism>> determineParallelismFunction, Function<VertexParallelism, Optional<ReservedSlots>> tryReserveResourcesFunction) {
        this.calculateRequiredSlotsFunction = calculateRequiredSlotsFunction;
        this.determineParallelismFunction = determineParallelismFunction;
        this.tryReserveResourcesFunction = tryReserveResourcesFunction;
    }

    public ResourceCounter calculateRequiredSlots(Iterable<JobInformation.VertexInformation> vertices) {
        return this.calculateRequiredSlotsFunction.apply(vertices);
    }

    public Optional<? extends VertexParallelism> determineParallelism(JobInformation jobInformation, Collection<? extends SlotInfo> slots) {
        return this.determineParallelismFunction.apply(jobInformation, slots);
    }

    public Optional<ReservedSlots> tryReserveResources(VertexParallelism vertexParallelism) {
        return this.tryReserveResourcesFunction.apply(vertexParallelism);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Function<Iterable<JobInformation.VertexInformation>, ResourceCounter> calculateRequiredSlotsFunction = ignored -> ResourceCounter.empty();
        private BiFunction<JobInformation, Collection<? extends SlotInfo>, Optional<? extends VertexParallelism>> determineParallelismFunction = (ignoredA, ignoredB) -> Optional.empty();
        private Function<VertexParallelism, Optional<ReservedSlots>> tryReserveResourcesFunction = ignored -> Optional.empty();

        public Builder setCalculateRequiredSlotsFunction(Function<Iterable<JobInformation.VertexInformation>, ResourceCounter> calculateRequiredSlotsFunction) {
            this.calculateRequiredSlotsFunction = calculateRequiredSlotsFunction;
            return this;
        }

        public Builder setDetermineParallelismFunction(BiFunction<JobInformation, Collection<? extends SlotInfo>, Optional<? extends VertexParallelism>> determineParallelismFunction) {
            this.determineParallelismFunction = determineParallelismFunction;
            return this;
        }

        public Builder setTryReserveResourcesFunction(Function<VertexParallelism, Optional<ReservedSlots>> tryReserveResourcesFunction) {
            this.tryReserveResourcesFunction = tryReserveResourcesFunction;
            return this;
        }

        public TestingSlotAllocator build() {
            return new TestingSlotAllocator(this.calculateRequiredSlotsFunction, this.determineParallelismFunction, this.tryReserveResourcesFunction);
        }
    }
}

