/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.source.coordinator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.api.connector.source.SplitsAssignment;
import org.apache.flink.api.connector.source.mocks.MockSourceSplit;
import org.apache.flink.util.function.ThrowingRunnable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

class CoordinatorTestUtils {
    CoordinatorTestUtils() {
    }

    static SplitsAssignment<MockSourceSplit> getSplitsAssignment(int numSubtasks, int startingSplitId) {
        HashMap assignments = new HashMap();
        int splitId = startingSplitId;
        for (int subtaskIndex = 0; subtaskIndex < numSubtasks; ++subtaskIndex) {
            ArrayList<MockSourceSplit> subtaskAssignment = new ArrayList<MockSourceSplit>();
            for (int j = 0; j < subtaskIndex + 1; ++j) {
                subtaskAssignment.add(new MockSourceSplit(splitId++));
            }
            assignments.put(subtaskIndex, subtaskAssignment);
        }
        return new SplitsAssignment(assignments);
    }

    static void verifyAssignment(List<String> expectedSplitIds, Collection<MockSourceSplit> actualAssignment) {
        Assert.assertEquals((long)expectedSplitIds.size(), (long)actualAssignment.size());
        int i = 0;
        for (MockSourceSplit split : actualAssignment) {
            Assert.assertEquals((Object)expectedSplitIds.get(i++), (Object)split.splitId());
        }
    }

    static void verifyException(ThrowingRunnable<Throwable> runnable, String failureMessage, String errorMessage) {
        try {
            runnable.run();
            Assert.fail((String)failureMessage);
        }
        catch (Throwable t) {
            Throwable rootCause = t;
            while (rootCause.getCause() != null) {
                rootCause = rootCause.getCause();
            }
            Assert.assertThat((Object)rootCause.getMessage(), (Matcher)Matchers.startsWith((String)errorMessage));
        }
    }
}

