/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.flink.runtime.taskexecutor.slot.TimeoutListener;
import org.apache.flink.runtime.taskexecutor.slot.TimerService;
import org.apache.flink.util.function.TriConsumer;

public class TestingTimerService<T>
implements TimerService<T> {
    private final Consumer<TimeoutListener<T>> startConsumer;
    private final Runnable stopConsumer;
    private final TriConsumer<T, Long, TimeUnit> registerTimeoutConsumer;
    private final Consumer<T> unregisterTimeoutConsumer;
    private final BiFunction<T, UUID, Boolean> isValidFunction;

    public TestingTimerService(Consumer<TimeoutListener<T>> startConsumer, Runnable stopConsumer, TriConsumer<T, Long, TimeUnit> registerTimeoutConsumer, Consumer<T> unregisterTimeoutConsumer, BiFunction<T, UUID, Boolean> isValidFunction) {
        this.startConsumer = startConsumer;
        this.stopConsumer = stopConsumer;
        this.registerTimeoutConsumer = registerTimeoutConsumer;
        this.unregisterTimeoutConsumer = unregisterTimeoutConsumer;
        this.isValidFunction = isValidFunction;
    }

    public void start(TimeoutListener<T> timeoutListener) {
        this.startConsumer.accept(timeoutListener);
    }

    public void stop() {
        this.stopConsumer.run();
    }

    public void registerTimeout(T key, long delay, TimeUnit unit) {
        this.registerTimeoutConsumer.accept(key, (Object)delay, (Object)unit);
    }

    public void unregisterTimeout(T key) {
        this.unregisterTimeoutConsumer.accept(key);
    }

    public boolean isValid(T key, UUID ticket) {
        return this.isValidFunction.apply(key, ticket);
    }
}

