/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.core.jackson;

import io.swagger.v3.oas.models.media.Schema;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.ResolvableSerializer;

public class SchemaSerializer
extends JsonSerializer<Schema>
implements ResolvableSerializer {
    private JsonSerializer<Object> defaultSerializer;

    public SchemaSerializer(JsonSerializer<Object> serializer) {
        this.defaultSerializer = serializer;
    }

    public void resolve(SerializerProvider serializerProvider) throws JsonMappingException {
        if (this.defaultSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)this.defaultSerializer).resolve(serializerProvider);
        }
    }

    public void serialize(Schema value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (StringUtils.isBlank(value.get$ref())) {
            this.defaultSerializer.serialize((Object)value, jgen, provider);
        } else {
            jgen.writeStartObject();
            jgen.writeStringField("$ref", value.get$ref());
            jgen.writeEndObject();
        }
    }
}

