/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.lifecycle.graph;

import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.flink.api.common.operators.ProcessingTimeService;
import org.apache.flink.runtime.operators.lifecycle.event.CheckpointCompletedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.CheckpointStartedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.InputEndedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.OperatorFinishedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.OperatorStartedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.TestEvent;
import org.apache.flink.runtime.operators.lifecycle.event.TestEventQueue;
import org.apache.flink.runtime.operators.lifecycle.event.WatermarkReceivedEvent;
import org.apache.flink.runtime.operators.lifecycle.graph.TestDataElement;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

class TwoInputTestStreamOperator
extends AbstractStreamOperator<TestDataElement>
implements TwoInputStreamOperator<TestDataElement, TestDataElement, TestDataElement>,
BoundedMultiInput,
ProcessingTimeService.ProcessingTimeCallback {
    private final String operatorID;
    private long lastDataSent;
    private final Map<String, OperatorFinishedEvent.LastVertexDataInfo> lastDataReceived = new HashMap<String, OperatorFinishedEvent.LastVertexDataInfo>();
    private boolean timerRegistered;
    private final TestEventQueue eventQueue;

    TwoInputTestStreamOperator(String operatorID, TestEventQueue eventQueue) {
        this.operatorID = operatorID;
        this.eventQueue = eventQueue;
    }

    public void open() throws Exception {
        super.open();
        this.eventQueue.add(new OperatorStartedEvent(this.operatorID, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getAttemptNumber()));
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        this.collectEvent(new CheckpointStartedEvent(this.operatorID, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getAttemptNumber(), context.getCheckpointId()));
        super.snapshotState(context);
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        this.collectEvent(new CheckpointCompletedEvent(this.operatorID, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getAttemptNumber(), checkpointId));
        super.notifyCheckpointComplete(checkpointId);
    }

    public void finish() throws Exception {
        this.collectEvent(new OperatorFinishedEvent(this.operatorID, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getAttemptNumber(), this.lastDataSent, new OperatorFinishedEvent.LastReceivedVertexDataInfo(this.lastDataReceived)));
        super.finish();
    }

    private void processElement(StreamRecord<TestDataElement> element) {
        TestDataElement e = (TestDataElement)element.getValue();
        this.lastDataReceived.computeIfAbsent((String)e.operatorId, (Function<String, OperatorFinishedEvent.LastVertexDataInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processElement$0(java.lang.String ), (Ljava/lang/String;)Lorg/apache/flink/runtime/operators/lifecycle/event/OperatorFinishedEvent$LastVertexDataInfo;)()).bySubtask.put(e.subtaskIndex, e.seq);
        this.output.collect((Object)new StreamRecord((Object)new TestDataElement(this.operatorID, this.getRuntimeContext().getIndexOfThisSubtask(), ++this.lastDataSent)));
        if (!this.timerRegistered) {
            this.registerTimer();
            this.timerRegistered = true;
        }
    }

    public void processWatermark1(Watermark mark) throws Exception {
        this.collectEvent(new WatermarkReceivedEvent(this.operatorID, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getAttemptNumber(), mark.getTimestamp(), 1));
        super.processWatermark1(mark);
    }

    public void processWatermark2(Watermark mark) throws Exception {
        this.collectEvent(new WatermarkReceivedEvent(this.operatorID, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getAttemptNumber(), mark.getTimestamp(), 2));
        super.processWatermark2(mark);
    }

    public void onProcessingTime(long timestamp) {
        this.registerTimer();
    }

    private void registerTimer() {
        this.getProcessingTimeService().registerTimer(this.getProcessingTimeService().getCurrentProcessingTime() + 1L, (ProcessingTimeService.ProcessingTimeCallback)this);
    }

    public void endInput(int inputId) throws Exception {
        this.collectEvent(new InputEndedEvent(this.operatorID, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getAttemptNumber(), inputId));
    }

    public void processElement1(StreamRecord element) {
        this.processElement((StreamRecord<TestDataElement>)element);
    }

    public void processElement2(StreamRecord element) {
        this.processElement((StreamRecord<TestDataElement>)element);
    }

    private void collectEvent(TestEvent e) {
        this.eventQueue.add(e);
    }

    private static /* synthetic */ OperatorFinishedEvent.LastVertexDataInfo lambda$processElement$0(String ign) {
        return new OperatorFinishedEvent.LastVertexDataInfo();
    }
}

