/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.test.util.TestProcessBuilder;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ExceptionUtilsITCase
extends TestLogger {
    private static final int DIRECT_MEMORY_SIZE = 10240;
    private static final int DIRECT_MEMORY_ALLOCATION_PAGE_SIZE = 1024;
    private static final int DIRECT_MEMORY_PAGE_NUMBER = 10;
    private static final long INITIAL_BIG_METASPACE_SIZE = 0x8000000L;
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();

    @Test
    public void testIsDirectOutOfMemoryError() throws IOException, InterruptedException {
        String className = DummyDirectAllocatingProgram.class.getName();
        RunResult result = ExceptionUtilsITCase.run(className, Collections.emptyList(), 10240L, -1L);
        Assert.assertThat((Object)(result.getErrorOut() + "|" + result.getStandardOut()), (Matcher)CoreMatchers.is((Object)"|"));
    }

    @Test
    public void testIsMetaspaceOutOfMemoryError() throws IOException, InterruptedException {
        String className = DummyClassLoadingProgram.class.getName();
        RunResult normalOut = ExceptionUtilsITCase.run(className, ExceptionUtilsITCase.getDummyClassLoadingProgramArgs(1), -1L, 0x8000000L);
        long okMetaspace = Long.parseLong(normalOut.getStandardOut());
        RunResult oomOut = ExceptionUtilsITCase.run(className, ExceptionUtilsITCase.getDummyClassLoadingProgramArgs(1000), -1L, okMetaspace);
        Assert.assertThat((Object)(oomOut.getErrorOut() + "|" + oomOut.getStandardOut()), (Matcher)CoreMatchers.is((Object)"|"));
    }

    private static RunResult run(String className, Iterable<String> args, long directMemorySize, long metaspaceSize) throws InterruptedException, IOException {
        TestProcessBuilder taskManagerProcessBuilder = new TestProcessBuilder(className);
        if (directMemorySize > 0L) {
            taskManagerProcessBuilder.addJvmArg(String.format("-XX:MaxDirectMemorySize=%d", directMemorySize));
        }
        if (metaspaceSize > 0L) {
            taskManagerProcessBuilder.addJvmArg("-XX:-UseCompressedOops");
            taskManagerProcessBuilder.addJvmArg(String.format("-XX:MaxMetaspaceSize=%d", metaspaceSize));
        }
        for (String arg : args) {
            taskManagerProcessBuilder.addMainClassArg(arg);
        }
        taskManagerProcessBuilder.withCleanEnvironment();
        TestProcessBuilder.TestProcess p = taskManagerProcessBuilder.start();
        p.getProcess().waitFor();
        return new RunResult(p.getErrorOutput().toString().trim(), p.getProcessOutput().toString().trim());
    }

    private static Collection<String> getDummyClassLoadingProgramArgs(int numberOfLoadedClasses) {
        return Arrays.asList(Integer.toString(numberOfLoadedClasses), TEMPORARY_FOLDER.getRoot().getAbsolutePath());
    }

    private static void output(String text) {
        System.out.println(text);
    }

    public static class DummyClassLoadingProgram {
        private DummyClassLoadingProgram() {
        }

        public static void main(String[] args) {
            ExceptionUtilsITCase.output("");
            ExceptionUtils.isMetaspaceOutOfMemoryError((Throwable)new Exception());
            ArrayList classes = new ArrayList();
            int numberOfLoadedClasses = Integer.parseInt(args[0]);
            try {
                for (int index = 0; index < numberOfLoadedClasses; ++index) {
                    classes.add(DummyClassLoadingProgram.loadDummyClass(index, args[1]));
                }
                String out = classes.size() > 1 ? "Exception is not thrown, metaspace usage: " : "";
                ExceptionUtilsITCase.output(out + DummyClassLoadingProgram.getMetaspaceUsage());
            }
            catch (Throwable t) {
                if (ExceptionUtils.isMetaspaceOutOfMemoryError((Throwable)t)) {
                    return;
                }
                ExceptionUtilsITCase.output("Wrong exception: " + t);
            }
        }

        private static Class<?> loadDummyClass(int index, String folderToSaveSource) throws ClassNotFoundException, IOException {
            String className = "DummyClass" + index;
            String sourcePattern = "public class %s { @Override public String toString() { return \"%s\"; } }";
            ClassLoaderUtils.ClassLoaderBuilder classLoaderBuilder = ClassLoaderUtils.withRoot((File)new File(folderToSaveSource));
            classLoaderBuilder.addClass(className, String.format(sourcePattern, className, "dummy"));
            URLClassLoader classLoader = classLoaderBuilder.build();
            return Class.forName(className, true, classLoader);
        }

        private static long getMetaspaceUsage() {
            for (MemoryPoolMXBean memoryMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
                if (!"Metaspace".equals(memoryMXBean.getName())) continue;
                return memoryMXBean.getUsage().getUsed();
            }
            throw new RuntimeException("Metaspace usage is not found");
        }
    }

    public static class DummyDirectAllocatingProgram {
        private DummyDirectAllocatingProgram() {
        }

        public static void main(String[] args) {
            block3: {
                try {
                    ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
                    for (int page = 0; page < 20; ++page) {
                        buffers.add(ByteBuffer.allocateDirect(1024));
                    }
                    ExceptionUtilsITCase.output("buffers: " + buffers);
                }
                catch (Throwable t) {
                    if (ExceptionUtils.isDirectOutOfMemoryError((Throwable)t)) break block3;
                    ExceptionUtilsITCase.output("Wrong exception: " + t);
                }
            }
        }
    }

    private static final class RunResult {
        private final String errorOut;
        private final String standardOut;

        public RunResult(String errorOut, String standardOut) {
            this.errorOut = errorOut;
            this.standardOut = standardOut;
        }

        public String getErrorOut() {
            return this.errorOut;
        }

        public String getStandardOut() {
            return this.standardOut;
        }
    }
}

