/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.checkpointing;

import java.io.File;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.test.checkpointing.ChangelogPeriodicMaterializationTestBase;
import org.apache.flink.testutils.junit.SharedReference;
import org.apache.flink.util.Preconditions;
import org.junit.Test;

public class ChangelogPeriodicMaterializationITCase
extends ChangelogPeriodicMaterializationTestBase {
    public ChangelogPeriodicMaterializationITCase(AbstractStateBackend delegatedStateBackend) {
        super(delegatedStateBackend);
    }

    @Test
    public void testNonMaterialization() throws Exception {
        final File checkpointFolder = TEMPORARY_FOLDER.newFolder();
        final SharedReference hasMaterialization = this.sharedObjects.add((Object)new AtomicBoolean(true));
        StreamExecutionEnvironment env = this.getEnv((StateBackend)this.delegatedStateBackend, checkpointFolder, 1000L, 1, -1L, 0);
        this.waitAndAssert(this.buildJobGraph(env, new ChangelogPeriodicMaterializationTestBase.ControlledSource(){

            @Override
            protected void beforeElement(SourceFunction.SourceContext<Integer> ctx) throws Exception {
                if (this.getRuntimeContext().getAttemptNumber() == 0 && this.currentIndex == 5000) {
                    this.waitWhile(() -> this.completedCheckpointNum.get() <= 0);
                    ((AtomicBoolean)hasMaterialization.get()).compareAndSet(true, !ChangelogPeriodicMaterializationTestBase.getAllStateHandleId(checkpointFolder).isEmpty());
                    this.throwArtificialFailure();
                }
            }
        }, this.generateJobID()));
        Preconditions.checkState((!((AtomicBoolean)hasMaterialization.get()).get() ? 1 : 0) != 0);
    }

    @Test
    public void testMaterialization() throws Exception {
        final File checkpointFolder = TEMPORARY_FOLDER.newFolder();
        final SharedReference currentCheckpointNum = this.sharedObjects.add((Object)new AtomicInteger());
        final SharedReference currentMaterializationId = this.sharedObjects.add(ConcurrentHashMap.newKeySet());
        StreamExecutionEnvironment env = this.getEnv((StateBackend)this.delegatedStateBackend, checkpointFolder, 100L, 2, 50L, 0);
        this.waitAndAssert(this.buildJobGraph(env, new ChangelogPeriodicMaterializationTestBase.ControlledSource(){

            @Override
            protected void beforeElement(SourceFunction.SourceContext<Integer> ctx) throws Exception {
                Preconditions.checkState((this.getRuntimeContext().getAttemptNumber() <= 2 ? 1 : 0) != 0);
                if (this.getRuntimeContext().getAttemptNumber() == 0 && this.currentIndex == 2500) {
                    this.waitWhile(() -> {
                        if (this.completedCheckpointNum.get() <= 0) {
                            return true;
                        }
                        Set<StateHandleID> allMaterializationId = ChangelogPeriodicMaterializationTestBase.getAllStateHandleId(checkpointFolder);
                        if (!allMaterializationId.isEmpty()) {
                            ((Set)currentMaterializationId.get()).addAll(allMaterializationId);
                            ((AtomicInteger)currentCheckpointNum.get()).compareAndSet(0, this.completedCheckpointNum.get());
                            return false;
                        }
                        return true;
                    });
                    this.throwArtificialFailure();
                } else if (this.getRuntimeContext().getAttemptNumber() == 1 && this.currentIndex == 5000) {
                    this.waitWhile(() -> {
                        if (this.completedCheckpointNum.get() <= ((AtomicInteger)currentCheckpointNum.get()).get()) {
                            return true;
                        }
                        Set<StateHandleID> allMaterializationId = ChangelogPeriodicMaterializationTestBase.getAllStateHandleId(checkpointFolder);
                        return allMaterializationId.isEmpty() || ((Set)currentMaterializationId.get()).equals(allMaterializationId);
                    });
                    this.throwArtificialFailure();
                }
            }
        }, this.generateJobID()));
    }

    @Test
    public void testFailedMaterialization() throws Exception {
        final File checkpointFolder = TEMPORARY_FOLDER.newFolder();
        final SharedReference hasFailed = this.sharedObjects.add((Object)new AtomicBoolean());
        final SharedReference currentMaterializationId = this.sharedObjects.add(ConcurrentHashMap.newKeySet());
        StreamExecutionEnvironment env = this.getEnv((StateBackend)new ChangelogPeriodicMaterializationTestBase.DelegatedStateBackendWrapper(this.delegatedStateBackend, snapshotResultFuture -> {
            if (((AtomicBoolean)hasFailed.get()).compareAndSet(false, true)) {
                throw new RuntimeException();
            }
            return snapshotResultFuture;
        }), checkpointFolder, 100L, 1, 10L, 1);
        env.setParallelism(1);
        this.waitAndAssert(this.buildJobGraph(env, new ChangelogPeriodicMaterializationTestBase.ControlledSource(){

            @Override
            protected void beforeElement(SourceFunction.SourceContext<Integer> ctx) throws Exception {
                if (this.currentIndex == 1250) {
                    this.waitWhile(() -> !((AtomicBoolean)hasFailed.get()).get());
                } else if (this.currentIndex == 2500) {
                    this.waitWhile(() -> {
                        Set<StateHandleID> allMaterializationId = ChangelogPeriodicMaterializationTestBase.getAllStateHandleId(checkpointFolder);
                        if (!allMaterializationId.isEmpty()) {
                            ((Set)currentMaterializationId.get()).addAll(allMaterializationId);
                            return false;
                        }
                        return true;
                    });
                } else if (this.currentIndex == 5000) {
                    this.waitWhile(() -> {
                        Set<StateHandleID> allMaterializationId = ChangelogPeriodicMaterializationTestBase.getAllStateHandleId(checkpointFolder);
                        return allMaterializationId.isEmpty() || ((Set)currentMaterializationId.get()).equals(allMaterializationId);
                    });
                }
            }
        }, this.generateJobID()));
    }
}

