/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.checkpointing;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichFilterFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.functions.RichReduceFunction;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.common.state.CheckpointListener;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.checkpoint.ListCheckpointed;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.co.CoFlatMapFunction;
import org.apache.flink.streaming.api.functions.co.RichCoFlatMapFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.source.RichParallelSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.test.util.TestUtils;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class CoStreamCheckpointingITCase
extends AbstractTestBase {
    private static final long NUM_STRINGS = 10000L;
    private static final int PARALLELISM = 4;

    @Test
    public void testCoStreamCheckpointingProgram() throws Exception {
        Assert.assertTrue((String)"Broken test setup", (boolean)true);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(4);
        env.enableCheckpointing(50L);
        env.setRestartStrategy(RestartStrategies.fixedDelayRestart((int)Integer.MAX_VALUE, (long)0L));
        DataStreamSource stream = env.addSource((SourceFunction)new StringGeneratingSourceFunction(10000L, 2000L));
        stream.filter((FilterFunction)new StringRichFilterFunction()).connect((DataStream)stream).flatMap((CoFlatMapFunction)new LeftIdentityCoRichFlatMapFunction()).map((MapFunction)new StringPrefixCountRichMapFunction()).startNewChain().map((MapFunction)new StatefulCounterFunction()).keyBy(new String[]{"prefix"}).reduce((ReduceFunction)new OnceFailingReducer(10000L)).addSink((SinkFunction)new SinkFunction<PrefixCount>(){

            public void invoke(PrefixCount value) {
            }
        });
        TestUtils.tryExecute(env, "Fault Tolerance Test");
        long filterSum = 0L;
        for (long l : StringRichFilterFunction.counts) {
            filterSum += l;
        }
        long coMapSum = 0L;
        for (long l : LeftIdentityCoRichFlatMapFunction.counts) {
            coMapSum += l;
        }
        long mapSum = 0L;
        for (long l : StringPrefixCountRichMapFunction.counts) {
            mapSum += l;
        }
        long countSum = 0L;
        for (long l : StatefulCounterFunction.counts) {
            countSum += l;
        }
        Assert.assertEquals((long)10000L, (long)filterSum);
        Assert.assertEquals((long)10000L, (long)coMapSum);
        Assert.assertEquals((long)10000L, (long)mapSum);
        Assert.assertEquals((long)10000L, (long)countSum);
    }

    public static class PrefixCount
    implements Serializable {
        public String prefix;
        public String value;
        public long count;

        public PrefixCount() {
        }

        public PrefixCount(String prefix, String value, long count) {
            this.prefix = prefix;
            this.value = value;
            this.count = count;
        }

        public String toString() {
            return this.prefix + " / " + this.value;
        }
    }

    private static class LeftIdentityCoRichFlatMapFunction
    extends RichCoFlatMapFunction<String, String, String>
    implements ListCheckpointed<Long> {
        static long[] counts = new long[4];
        private long count;

        private LeftIdentityCoRichFlatMapFunction() {
        }

        public void flatMap1(String value, Collector<String> out) {
            ++this.count;
            out.collect((Object)value);
        }

        public void flatMap2(String value, Collector<String> out) {
        }

        public List<Long> snapshotState(long checkpointId, long timestamp) throws Exception {
            return Collections.singletonList(this.count);
        }

        public void restoreState(List<Long> state) throws Exception {
            if (state.isEmpty() || state.size() > 1) {
                throw new RuntimeException("Test failed due to unexpected recovered state size " + state.size());
            }
            this.count = state.get(0);
        }

        public void close() throws IOException {
            LeftIdentityCoRichFlatMapFunction.counts[this.getRuntimeContext().getIndexOfThisSubtask()] = this.count;
        }
    }

    private static class StringPrefixCountRichMapFunction
    extends RichMapFunction<String, PrefixCount>
    implements ListCheckpointed<Long> {
        static long[] counts = new long[4];
        private long count;

        private StringPrefixCountRichMapFunction() {
        }

        public PrefixCount map(String value) {
            ++this.count;
            return new PrefixCount(value.substring(0, 1), value, 1L);
        }

        public List<Long> snapshotState(long checkpointId, long timestamp) throws Exception {
            return Collections.singletonList(this.count);
        }

        public void restoreState(List<Long> state) throws Exception {
            if (state.isEmpty() || state.size() > 1) {
                throw new RuntimeException("Test failed due to unexpected recovered state size " + state.size());
            }
            this.count = state.get(0);
        }

        public void close() throws IOException {
            StringPrefixCountRichMapFunction.counts[this.getRuntimeContext().getIndexOfThisSubtask()] = this.count;
        }
    }

    private static class StringRichFilterFunction
    extends RichFilterFunction<String>
    implements ListCheckpointed<Long> {
        static long[] counts = new long[4];
        private long count = 0L;

        private StringRichFilterFunction() {
        }

        public boolean filter(String value) {
            ++this.count;
            return value.length() < 100;
        }

        public void close() {
            StringRichFilterFunction.counts[this.getRuntimeContext().getIndexOfThisSubtask()] = this.count;
        }

        public List<Long> snapshotState(long checkpointId, long timestamp) throws Exception {
            return Collections.singletonList(this.count);
        }

        public void restoreState(List<Long> state) throws Exception {
            if (state.isEmpty() || state.size() > 1) {
                throw new RuntimeException("Test failed due to unexpected recovered state size " + state.size());
            }
            this.count = state.get(0);
        }
    }

    private static class OnceFailingReducer
    extends RichReduceFunction<PrefixCount> {
        private static volatile boolean hasFailed = false;
        private final long numElements;
        private long failurePos;
        private long count;

        OnceFailingReducer(long numElements) {
            this.numElements = numElements;
        }

        public void open(Configuration parameters) {
            long failurePosMin = (long)(0.4 * (double)this.numElements / (double)this.getRuntimeContext().getNumberOfParallelSubtasks());
            long failurePosMax = (long)(0.7 * (double)this.numElements / (double)this.getRuntimeContext().getNumberOfParallelSubtasks());
            this.failurePos = new Random().nextLong() % (failurePosMax - failurePosMin) + failurePosMin;
            this.count = 0L;
        }

        public PrefixCount reduce(PrefixCount value1, PrefixCount value2) throws Exception {
            ++this.count;
            if (!hasFailed && this.count >= this.failurePos) {
                hasFailed = true;
                throw new Exception("Test Failure");
            }
            value1.count += value2.count;
            return value1;
        }
    }

    private static class StatefulCounterFunction
    extends RichMapFunction<PrefixCount, PrefixCount>
    implements ListCheckpointed<Long> {
        static long[] counts = new long[4];
        private long count;

        private StatefulCounterFunction() {
        }

        public PrefixCount map(PrefixCount value) throws Exception {
            ++this.count;
            return value;
        }

        public void close() throws IOException {
            StatefulCounterFunction.counts[this.getRuntimeContext().getIndexOfThisSubtask()] = this.count;
        }

        public List<Long> snapshotState(long checkpointId, long timestamp) throws Exception {
            return Collections.singletonList(this.count);
        }

        public void restoreState(List<Long> state) throws Exception {
            if (state.isEmpty() || state.size() > 1) {
                throw new RuntimeException("Test failed due to unexpected recovered state size " + state.size());
            }
            this.count = state.get(0);
        }
    }

    private static class StringGeneratingSourceFunction
    extends RichParallelSourceFunction<String>
    implements ListCheckpointed<Integer>,
    CheckpointListener {
        private static volatile int numCompletedCheckpoints = 0;
        private final long numElements;
        private final long checkpointLatestAt;
        private int index = -1;
        private volatile boolean isRunning = true;

        StringGeneratingSourceFunction(long numElements, long checkpointLatestAt) {
            this.numElements = numElements;
            this.checkpointLatestAt = checkpointLatestAt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(SourceFunction.SourceContext<String> ctx) throws Exception {
            Random rnd = new Random();
            StringBuilder stringBuilder = new StringBuilder();
            Object lockingObject = ctx.getCheckpointLock();
            int step = this.getRuntimeContext().getNumberOfParallelSubtasks();
            if (this.index < 0) {
                this.index = this.getRuntimeContext().getIndexOfThisSubtask();
            }
            while (this.isRunning && (long)this.index < this.numElements) {
                char first = (char)(this.index % 40 + 40);
                stringBuilder.setLength(0);
                stringBuilder.append(first);
                String result = StringGeneratingSourceFunction.randomString(stringBuilder, rnd);
                Object object = lockingObject;
                synchronized (object) {
                    this.index += step;
                    ctx.collect((Object)result);
                }
                if (numCompletedCheckpoints >= 2) continue;
                if ((long)this.index < this.checkpointLatestAt) {
                    Thread.sleep(1L);
                    continue;
                }
                while (this.isRunning && numCompletedCheckpoints < 2) {
                    Thread.sleep(5L);
                }
            }
        }

        public void cancel() {
            this.isRunning = false;
        }

        public List<Integer> snapshotState(long checkpointId, long timestamp) throws Exception {
            return Collections.singletonList(this.index);
        }

        public void restoreState(List<Integer> state) throws Exception {
            if (state.isEmpty() || state.size() > 1) {
                throw new RuntimeException("Test failed due to unexpected recovered state size " + state.size());
            }
            this.index = state.get(0);
        }

        public void notifyCheckpointComplete(long checkpointId) throws Exception {
            if (this.getRuntimeContext().getIndexOfThisSubtask() == 0) {
                ++numCompletedCheckpoints;
            }
        }

        public void notifyCheckpointAborted(long checkpointId) {
        }

        private static String randomString(StringBuilder bld, Random rnd) {
            int len = rnd.nextInt(10) + 5;
            for (int i = 0; i < len; ++i) {
                char next = (char)(rnd.nextInt(20000) + 33);
                bld.append(next);
            }
            return bld.toString();
        }
    }
}

