/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.checkpointing;

import java.net.InetAddress;
import java.util.concurrent.Executor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.LocalConnectionManager;
import org.apache.flink.runtime.io.network.NettyShuffleServiceFactory;
import org.apache.flink.runtime.io.network.TaskEventPublisher;
import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.io.network.netty.NettyConnectionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.shuffle.NettyShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleEnvironment;
import org.apache.flink.runtime.shuffle.ShuffleEnvironmentContext;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.runtime.shuffle.ShuffleMasterContext;
import org.apache.flink.runtime.shuffle.ShuffleServiceFactory;
import org.apache.flink.runtime.taskmanager.NettyShuffleEnvironmentConfiguration;
import org.apache.flink.util.Preconditions;

public final class SharedPoolNettyShuffleServiceFactory
implements ShuffleServiceFactory<NettyShuffleDescriptor, ResultPartition, SingleInputGate> {
    private final NettyShuffleServiceFactory nettyShuffleServiceFactory = new NettyShuffleServiceFactory();
    private static NettyBufferPool bufferPool;

    public static void resetBufferPool(int numberOfArenas) {
        bufferPool = new NettyBufferPool(numberOfArenas);
    }

    public static void clearBufferPool() {
        bufferPool = null;
    }

    public ShuffleMaster<NettyShuffleDescriptor> createShuffleMaster(ShuffleMasterContext shuffleMasterContext) {
        return this.nettyShuffleServiceFactory.createShuffleMaster(shuffleMasterContext);
    }

    public ShuffleEnvironment<ResultPartition, SingleInputGate> createShuffleEnvironment(ShuffleEnvironmentContext shuffleEnvironmentContext) {
        Preconditions.checkNotNull((Object)shuffleEnvironmentContext);
        NettyShuffleEnvironmentConfiguration networkConfig = NettyShuffleEnvironmentConfiguration.fromConfiguration((Configuration)shuffleEnvironmentContext.getConfiguration(), (MemorySize)shuffleEnvironmentContext.getNetworkMemorySize(), (boolean)shuffleEnvironmentContext.isLocalCommunicationOnly(), (InetAddress)shuffleEnvironmentContext.getHostAddress());
        NettyConfig nettyConfig = networkConfig.nettyConfig();
        TaskEventPublisher taskEventPublisher = shuffleEnvironmentContext.getEventPublisher();
        ResultPartitionManager resultPartitionManager = new ResultPartitionManager();
        NettyConnectionManager connectionManager = nettyConfig != null ? new NettyConnectionManager(bufferPool, (ResultPartitionProvider)resultPartitionManager, taskEventPublisher, nettyConfig, networkConfig.getMaxNumberOfConnections(), networkConfig.isConnectionReuseEnabled()) : new LocalConnectionManager();
        return NettyShuffleServiceFactory.createNettyShuffleEnvironment((NettyShuffleEnvironmentConfiguration)networkConfig, (ResourceID)shuffleEnvironmentContext.getTaskExecutorResourceId(), (TaskEventPublisher)taskEventPublisher, (ResultPartitionManager)resultPartitionManager, (ConnectionManager)connectionManager, (MetricGroup)shuffleEnvironmentContext.getParentMetricGroup(), (Executor)shuffleEnvironmentContext.getIoExecutor());
    }
}

