/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.planning;

import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.junit.Test;

public class LargePlanTest {
    @Test(timeout=30000L)
    public void testPlanningOfLargePlan() throws Exception {
        LargePlanTest.runProgram(10, 20);
    }

    private static void runProgram(int depth, int width) throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new String[]{"a", "b", "c"});
        DataSet<String> stats = null;
        for (int i = 0; i < depth; ++i) {
            stats = LargePlanTest.analyze((DataSet<String>)input, stats, width / (i + 1) + 1);
        }
        stats.output((OutputFormat)new DiscardingOutputFormat());
        env.createProgramPlan("depth " + depth + " width " + width);
    }

    private static DataSet<String> analyze(DataSet<String> input, DataSet<String> stats, int branches) {
        for (int i = 0; i < branches; ++i) {
            int ii = i;
            if (stats != null) {
                input = input.map((MapFunction)new RichMapFunction<String, String>(){

                    public String map(String value) {
                        return value;
                    }
                }).withBroadcastSet((DataSet)stats.map((MapFunction & Serializable)s -> "(" + s + ").map"), "stats");
            }
            SingleInputUdfOperator branch = ((MapOperator)input.map((MapFunction & Serializable)s -> new Tuple2((Object)0, (Object)(s + ii))).returns(Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.STRING, Types.INT}))).groupBy(new int[]{0}).minBy(new int[]{1}).map((MapFunction & Serializable)kv -> (String)kv.f1).returns(Types.STRING);
            stats = stats == null ? branch : stats.union((DataSet)branch);
        }
        return stats.map((MapFunction & Serializable)s -> "(" + s + ").stats");
    }
}

