/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.runtime;

import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.junit.AssumptionViolatedException;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyEpollITCase
extends TestLogger {
    private static final Logger LOG = LoggerFactory.getLogger(NettyEpollITCase.class);
    private static final int NUM_TASK_MANAGERS = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNettyEpoll() throws Exception {
        MiniClusterWithClientResource cluster = this.trySetUpCluster();
        try {
            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(2);
            DataStreamSource input = env.fromElements((Object[])new Integer[]{1, 2, 3, 4, 1, 2, 3, 42});
            input.keyBy((KeySelector)new KeySelector<Integer, Integer>(){

                public Integer getKey(Integer value) throws Exception {
                    return value;
                }
            }).sum(0).print();
            env.execute();
        }
        finally {
            cluster.after();
        }
    }

    private MiniClusterWithClientResource trySetUpCluster() throws Exception {
        try {
            Configuration config = new Configuration();
            config.setString(NettyShuffleEnvironmentOptions.TRANSPORT_TYPE, "epoll");
            MiniClusterWithClientResource cluster = new MiniClusterWithClientResource(new MiniClusterResourceConfiguration.Builder().setConfiguration(config).setNumberTaskManagers(2).setNumberSlotsPerTaskManager(1).build());
            cluster.before();
            return cluster;
        }
        catch (UnsatisfiedLinkError ex) {
            if (ExceptionUtils.findThrowableWithMessage((Throwable)ex, (String)"Only supported on Linux").isPresent()) {
                throw new AssumptionViolatedException("This test is only supported on linux");
            }
            throw ex;
        }
    }
}

