/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Planner;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.UTCClock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class SimpleCapacityReplanner
implements Planner {
    private static final Log LOG = LogFactory.getLog(SimpleCapacityReplanner.class);
    private static final Resource ZERO_RESOURCE = Resource.newInstance((int)0, (int)0);
    private final Clock clock;
    private long lengthOfCheckZone;

    public SimpleCapacityReplanner() {
        this((Clock)new UTCClock());
    }

    @VisibleForTesting
    SimpleCapacityReplanner(Clock clock) {
        this.clock = clock;
    }

    @Override
    public void init(String planQueueName, ReservationSchedulerConfiguration conf) {
        this.lengthOfCheckZone = conf.getEnforcementWindow(planQueueName);
    }

    @Override
    public void plan(Plan plan, List<ReservationDefinition> contracts) throws PlanningException {
        long now;
        if (contracts != null) {
            throw new RuntimeException("SimpleCapacityReplanner cannot handle new reservation contracts");
        }
        ResourceCalculator resCalc = plan.getResourceCalculator();
        Resource totCap = plan.getTotalCapacity();
        for (long t = now = this.clock.getTime(); t < plan.getLastEndTime() && t < now + this.lengthOfCheckZone; t += plan.getStep()) {
            Resource excessCap = Resources.subtract((Resource)plan.getTotalCommittedResources(t), (Resource)totCap);
            if (!Resources.greaterThan((ResourceCalculator)resCalc, (Resource)totCap, (Resource)excessCap, (Resource)ZERO_RESOURCE)) continue;
            TreeSet<ReservationAllocation> curReservations = new TreeSet<ReservationAllocation>(plan.getReservationsAtTime(t));
            Iterator resIter = curReservations.iterator();
            while (resIter.hasNext() && Resources.greaterThan((ResourceCalculator)resCalc, (Resource)totCap, (Resource)excessCap, (Resource)ZERO_RESOURCE)) {
                ReservationAllocation reservation = (ReservationAllocation)resIter.next();
                plan.deleteReservation(reservation.getReservationId());
                excessCap = Resources.subtract((Resource)excessCap, (Resource)reservation.getResourcesAtTime(t));
                LOG.info((Object)("Removing reservation " + reservation.getReservationId() + " to repair physical-resource constraints in the plan: " + plan.getQueueName()));
            }
        }
    }
}

