/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.ResourceTracker;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryServer;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.MemoryApplicationHistoryStore;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.NodeHealthCheckerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeManager;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdaterImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptRegistrationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptUnregistrationEvent;
import org.apache.hadoop.yarn.server.timeline.MemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.recovery.MemoryTimelineStateStore;
import org.apache.hadoop.yarn.server.timeline.recovery.TimelineStateStore;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MiniYARNCluster
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(MiniYARNCluster.class);
    private NodeManager[] nodeManagers;
    private ResourceManager[] resourceManagers;
    private String[] rmIds;
    private ApplicationHistoryServer appHistoryServer;
    private boolean useFixedPorts;
    private boolean useRpc = false;
    private int failoverTimeout;
    private ConcurrentMap<ApplicationAttemptId, Long> appMasters = new ConcurrentHashMap<ApplicationAttemptId, Long>(16, 0.75f, 2);
    private File testWorkDir;
    private int numLocalDirs;
    private int numLogDirs;
    private boolean enableAHS;

    public MiniYARNCluster(String testName, int numResourceManagers, int numNodeManagers, int numLocalDirs, int numLogDirs, boolean enableAHS) {
        super(testName.replace("$", ""));
        this.numLocalDirs = numLocalDirs;
        this.numLogDirs = numLogDirs;
        this.enableAHS = enableAHS;
        String testSubDir = testName.replace("$", "");
        File targetWorkDir = new File("target", testSubDir);
        try {
            FileContext.getLocalFSFileContext().delete(new Path(targetWorkDir.getAbsolutePath()), true);
        }
        catch (Exception e) {
            LOG.warn((Object)"COULD NOT CLEANUP", (Throwable)e);
            throw new YarnRuntimeException("could not cleanup test dir: " + e, (Throwable)e);
        }
        if (Shell.WINDOWS) {
            String targetPath = targetWorkDir.getAbsolutePath();
            File link = new File(System.getProperty("java.io.tmpdir"), String.valueOf(System.currentTimeMillis()));
            String linkPath = link.getAbsolutePath();
            try {
                FileContext.getLocalFSFileContext().delete(new Path(linkPath), true);
            }
            catch (IOException e) {
                throw new YarnRuntimeException("could not cleanup symlink: " + linkPath, (Throwable)e);
            }
            targetWorkDir.mkdirs();
            Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(Shell.getSymlinkCommand((String)targetPath, (String)linkPath));
            try {
                shexec.execute();
            }
            catch (IOException e) {
                throw new YarnRuntimeException(String.format("failed to create symlink from %s to %s, shell output: %s", linkPath, targetPath, shexec.getOutput()), (Throwable)e);
            }
            this.testWorkDir = link;
        } else {
            this.testWorkDir = targetWorkDir;
        }
        this.resourceManagers = new ResourceManager[numResourceManagers];
        this.nodeManagers = new NodeManager[numNodeManagers];
    }

    public MiniYARNCluster(String testName, int numResourceManagers, int numNodeManagers, int numLocalDirs, int numLogDirs) {
        this(testName, numResourceManagers, numNodeManagers, numLocalDirs, numLogDirs, false);
    }

    public MiniYARNCluster(String testName, int numNodeManagers, int numLocalDirs, int numLogDirs) {
        this(testName, 1, numNodeManagers, numLocalDirs, numLogDirs);
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.useFixedPorts = conf.getBoolean("yarn.minicluster.fixed.ports", false);
        this.useRpc = conf.getBoolean("yarn.minicluster.use-rpc", false);
        this.failoverTimeout = conf.getInt("yarn.resourcemanager.zk-timeout-ms", 10000);
        if (this.useRpc && !this.useFixedPorts) {
            throw new YarnRuntimeException("Invalid configuration! Minicluster can use rpc only when configured to use fixed ports");
        }
        conf.setBoolean("yarn.is.minicluster", true);
        if (this.resourceManagers.length > 1) {
            conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
            if (conf.get("yarn.resourcemanager.ha.rm-ids") == null) {
                StringBuilder rmIds = new StringBuilder();
                for (int i = 0; i < this.resourceManagers.length; ++i) {
                    if (i != 0) {
                        rmIds.append(",");
                    }
                    rmIds.append("rm" + i);
                }
                conf.set("yarn.resourcemanager.ha.rm-ids", rmIds.toString());
            }
            Collection rmIdsCollection = HAUtil.getRMHAIds((Configuration)conf);
            this.rmIds = rmIdsCollection.toArray(new String[rmIdsCollection.size()]);
        }
        for (int i = 0; i < this.resourceManagers.length; ++i) {
            this.resourceManagers[i] = this.createResourceManager();
            if (!this.useFixedPorts) {
                if (HAUtil.isHAEnabled((Configuration)conf)) {
                    this.setHARMConfigurationWithEphemeralPorts(i, conf);
                } else {
                    this.setNonHARMConfigurationWithEphemeralPorts(conf);
                }
            }
            this.addService((Service)new ResourceManagerWrapper(i));
        }
        for (int index = 0; index < this.nodeManagers.length; ++index) {
            this.nodeManagers[index] = this.useRpc ? new CustomNodeManager() : new ShortCircuitedNodeManager();
            this.addService((Service)new NodeManagerWrapper(index));
        }
        if (conf.getBoolean("yarn.timeline-service.enabled", false) || this.enableAHS) {
            this.addService((Service)new ApplicationHistoryServerWrapper());
        }
        super.serviceInit((Configuration)(conf instanceof YarnConfiguration ? conf : new YarnConfiguration(conf)));
    }

    private void setNonHARMConfigurationWithEphemeralPorts(Configuration conf) {
        String hostname = MiniYARNCluster.getHostname();
        conf.set("yarn.resourcemanager.address", hostname + ":0");
        conf.set("yarn.resourcemanager.admin.address", hostname + ":0");
        conf.set("yarn.resourcemanager.scheduler.address", hostname + ":0");
        conf.set("yarn.resourcemanager.resource-tracker.address", hostname + ":0");
        WebAppUtils.setRMWebAppHostnameAndPort((Configuration)conf, (String)hostname, (int)0);
    }

    private void setHARMConfigurationWithEphemeralPorts(int index, Configuration conf) {
        String hostname = MiniYARNCluster.getHostname();
        for (String confKey : YarnConfiguration.getServiceAddressConfKeys((Configuration)conf)) {
            conf.set(HAUtil.addSuffix((String)confKey, (String)this.rmIds[index]), hostname + ":0");
        }
    }

    private synchronized void initResourceManager(int index, Configuration conf) {
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            conf.set("yarn.resourcemanager.ha.id", this.rmIds[index]);
        }
        this.resourceManagers[index].init(conf);
        this.resourceManagers[index].getRMContext().getDispatcher().register(RMAppAttemptEventType.class, (EventHandler)new EventHandler<RMAppAttemptEvent>(){

            public void handle(RMAppAttemptEvent event) {
                if (event instanceof RMAppAttemptRegistrationEvent) {
                    MiniYARNCluster.this.appMasters.put(event.getApplicationAttemptId(), event.getTimestamp());
                } else if (event instanceof RMAppAttemptUnregistrationEvent) {
                    MiniYARNCluster.this.appMasters.remove(event.getApplicationAttemptId());
                }
            }
        });
    }

    private synchronized void startResourceManager(final int index) {
        try {
            Thread rmThread = new Thread(){

                @Override
                public void run() {
                    MiniYARNCluster.this.resourceManagers[index].start();
                }
            };
            rmThread.setName("RM-" + index);
            rmThread.start();
            int waitCount = 0;
            while (this.resourceManagers[index].getServiceState() == Service.STATE.INITED && waitCount++ < 60) {
                LOG.info((Object)"Waiting for RM to start...");
                Thread.sleep(1500L);
            }
            if (this.resourceManagers[index].getServiceState() != Service.STATE.STARTED) {
                throw new IOException("ResourceManager failed to start. Final state is " + this.resourceManagers[index].getServiceState());
            }
        }
        catch (Throwable t) {
            throw new YarnRuntimeException(t);
        }
        LOG.info((Object)("MiniYARN ResourceManager address: " + this.getConfig().get("yarn.resourcemanager.address")));
        LOG.info((Object)("MiniYARN ResourceManager web address: " + WebAppUtils.getRMWebAppURLWithoutScheme((Configuration)this.getConfig())));
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized void stopResourceManager(int index) {
        if (this.resourceManagers[index] != null) {
            this.resourceManagers[index].stop();
            this.resourceManagers[index] = null;
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized void restartResourceManager(int index) throws InterruptedException {
        if (this.resourceManagers[index] != null) {
            this.resourceManagers[index].stop();
            this.resourceManagers[index] = null;
        }
        Configuration conf = this.getConfig();
        this.resourceManagers[index] = new ResourceManager();
        this.initResourceManager(index, this.getConfig());
        this.startResourceManager(index);
    }

    public File getTestWorkDir() {
        return this.testWorkDir;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public int getActiveRMIndex() {
        if (this.resourceManagers.length == 1) {
            return 0;
        }
        int numRetriesForRMBecomingActive = this.failoverTimeout / 100;
        while (numRetriesForRMBecomingActive-- > 0) {
            for (int i = 0; i < this.resourceManagers.length; ++i) {
                if (this.resourceManagers[i] == null) continue;
                try {
                    if (HAServiceProtocol.HAServiceState.ACTIVE != this.resourceManagers[i].getRMContext().getRMAdminService().getServiceStatus().getState()) continue;
                    return i;
                }
                catch (IOException e) {
                    throw new YarnRuntimeException("Couldn't read the status of a ResourceManger in the HA ensemble.", (Throwable)e);
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new YarnRuntimeException("Interrupted while waiting for one of the ResourceManagers to become active");
            }
        }
        return -1;
    }

    public ResourceManager getResourceManager() {
        int activeRMIndex = this.getActiveRMIndex();
        return activeRMIndex == -1 ? null : this.resourceManagers[activeRMIndex];
    }

    public ResourceManager getResourceManager(int i) {
        return this.resourceManagers[i];
    }

    public NodeManager getNodeManager(int i) {
        return this.nodeManagers[i];
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean waitForNodeManagersToConnect(long timeout) throws YarnException, InterruptedException {
        GetClusterMetricsRequest req = GetClusterMetricsRequest.newInstance();
        int i = 0;
        while ((long)i < timeout / 100L) {
            ResourceManager rm = this.getResourceManager();
            if (rm == null) {
                throw new YarnException("Can not find the active RM.");
            }
            if (this.nodeManagers.length == rm.getClientRMService().getClusterMetrics(req).getClusterMetrics().getNumNodeManagers()) {
                return true;
            }
            Thread.sleep(100L);
            ++i;
        }
        return false;
    }

    public ApplicationHistoryServer getApplicationHistoryServer() {
        return this.appHistoryServer;
    }

    protected ResourceManager createResourceManager() {
        return new ResourceManager(){

            protected void doSecureLogin() throws IOException {
            }
        };
    }

    public int getNumOfResourceManager() {
        return this.resourceManagers.length;
    }

    static {
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
    }

    private class ApplicationHistoryServerWrapper
    extends AbstractService {
        public ApplicationHistoryServerWrapper() {
            super(ApplicationHistoryServerWrapper.class.getName());
        }

        protected synchronized void serviceInit(Configuration conf) throws Exception {
            MiniYARNCluster.this.appHistoryServer = new ApplicationHistoryServer();
            conf.setClass("yarn.timeline-service.generic-application-history.store-class", MemoryApplicationHistoryStore.class, ApplicationHistoryStore.class);
            conf.setClass("yarn.timeline-service.store-class", MemoryTimelineStore.class, TimelineStore.class);
            conf.setClass("yarn.timeline-service.state-store-class", MemoryTimelineStateStore.class, TimelineStateStore.class);
            if (!MiniYARNCluster.this.useFixedPorts) {
                String hostname = MiniYARNCluster.getHostname();
                conf.set("yarn.timeline-service.address", hostname + ":0");
                conf.set("yarn.timeline-service.webapp.address", hostname + ":0");
            }
            MiniYARNCluster.this.appHistoryServer.init(conf);
            super.serviceInit(conf);
        }

        protected synchronized void serviceStart() throws Exception {
            try {
                new Thread(){

                    @Override
                    public void run() {
                        MiniYARNCluster.this.appHistoryServer.start();
                    }
                }.start();
                int waitCount = 0;
                while (MiniYARNCluster.this.appHistoryServer.getServiceState() == Service.STATE.INITED && waitCount++ < 60) {
                    LOG.info((Object)"Waiting for Timeline Server to start...");
                    Thread.sleep(1500L);
                }
                if (MiniYARNCluster.this.appHistoryServer.getServiceState() != Service.STATE.STARTED) {
                    throw new IOException("ApplicationHistoryServer failed to start. Final state is " + MiniYARNCluster.this.appHistoryServer.getServiceState());
                }
                super.serviceStart();
            }
            catch (Throwable t) {
                throw new YarnRuntimeException(t);
            }
            LOG.info((Object)("MiniYARN ApplicationHistoryServer address: " + this.getConfig().get("yarn.timeline-service.address")));
            LOG.info((Object)("MiniYARN ApplicationHistoryServer web address: " + this.getConfig().get("yarn.timeline-service.webapp.address")));
        }

        protected synchronized void serviceStop() throws Exception {
            if (MiniYARNCluster.this.appHistoryServer != null) {
                MiniYARNCluster.this.appHistoryServer.stop();
            }
        }
    }

    private class ShortCircuitedNodeManager
    extends CustomNodeManager {
        private ShortCircuitedNodeManager() {
        }

        protected NodeStatusUpdater createNodeStatusUpdater(Context context, Dispatcher dispatcher, NodeHealthCheckerService healthChecker) {
            return new NodeStatusUpdaterImpl(context, dispatcher, healthChecker, this.metrics){

                protected ResourceTracker getRMClient() {
                    final ResourceTrackerService rt = MiniYARNCluster.this.getResourceManager().getResourceTrackerService();
                    RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
                    return new ResourceTracker(){

                        public NodeHeartbeatResponse nodeHeartbeat(NodeHeartbeatRequest request) throws YarnException, IOException {
                            NodeHeartbeatResponse response;
                            try {
                                response = rt.nodeHeartbeat(request);
                            }
                            catch (YarnException e) {
                                LOG.info((Object)("Exception in heartbeat from node " + request.getNodeStatus().getNodeId()), (Throwable)e);
                                throw e;
                            }
                            return response;
                        }

                        public RegisterNodeManagerResponse registerNodeManager(RegisterNodeManagerRequest request) throws YarnException, IOException {
                            RegisterNodeManagerResponse response;
                            try {
                                response = rt.registerNodeManager(request);
                            }
                            catch (YarnException e) {
                                LOG.info((Object)("Exception in node registration from " + request.getNodeId().toString()), (Throwable)e);
                                throw e;
                            }
                            return response;
                        }
                    };
                }

                protected void stopRMProxy() {
                }
            };
        }
    }

    private class CustomNodeManager
    extends NodeManager {
        private CustomNodeManager() {
        }

        protected void doSecureLogin() throws IOException {
        }
    }

    private class NodeManagerWrapper
    extends AbstractService {
        int index;

        public NodeManagerWrapper(int i) {
            super(NodeManagerWrapper.class.getName() + "_" + i);
            this.index = 0;
            this.index = i;
        }

        protected synchronized void serviceInit(Configuration conf) throws Exception {
            YarnConfiguration config = new YarnConfiguration(conf);
            String localDirsString = this.prepareDirs("local", MiniYARNCluster.this.numLocalDirs);
            config.set("yarn.nodemanager.local-dirs", localDirsString);
            String logDirsString = this.prepareDirs("log", MiniYARNCluster.this.numLogDirs);
            config.set("yarn.nodemanager.log-dirs", logDirsString);
            config.setInt("yarn.nodemanager.resource.memory-mb", config.getInt("yarn.minicluster.yarn.nodemanager.resource.memory-mb", 4096));
            config.set("yarn.nodemanager.address", MiniYARNCluster.getHostname() + ":0");
            config.set("yarn.nodemanager.localizer.address", MiniYARNCluster.getHostname() + ":0");
            WebAppUtils.setNMWebAppHostNameAndPort((Configuration)config, (String)MiniYARNCluster.getHostname(), (int)0);
            if (!config.getBoolean("yarn.minicluster.control-resource-monitoring", false)) {
                config.setBoolean("yarn.nodemanager.pmem-check-enabled", false);
                config.setBoolean("yarn.nodemanager.vmem-check-enabled", false);
            }
            LOG.info((Object)("Starting NM: " + this.index));
            MiniYARNCluster.this.nodeManagers[this.index].init((Configuration)config);
            super.serviceInit((Configuration)config);
        }

        private String prepareDirs(String dirType, int numDirs) {
            File[] dirs = new File[numDirs];
            String dirsString = "";
            for (int i = 0; i < numDirs; ++i) {
                dirs[i] = new File(MiniYARNCluster.this.testWorkDir, MiniYARNCluster.this.getName() + "-" + dirType + "Dir-nm-" + this.index + "_" + i);
                dirs[i].mkdirs();
                LOG.info((Object)("Created " + dirType + "Dir in " + dirs[i].getAbsolutePath()));
                String delimiter = i > 0 ? "," : "";
                dirsString = dirsString.concat(delimiter + dirs[i].getAbsolutePath());
            }
            return dirsString;
        }

        protected synchronized void serviceStart() throws Exception {
            try {
                new Thread(){

                    @Override
                    public void run() {
                        MiniYARNCluster.this.nodeManagers[NodeManagerWrapper.this.index].start();
                    }
                }.start();
                int waitCount = 0;
                while (MiniYARNCluster.this.nodeManagers[this.index].getServiceState() == Service.STATE.INITED && waitCount++ < 60) {
                    LOG.info((Object)("Waiting for NM " + this.index + " to start..."));
                    Thread.sleep(1000L);
                }
                if (MiniYARNCluster.this.nodeManagers[this.index].getServiceState() != Service.STATE.STARTED) {
                    throw new IOException("NodeManager " + this.index + " failed to start");
                }
                super.serviceStart();
            }
            catch (Throwable t) {
                throw new YarnRuntimeException(t);
            }
        }

        protected synchronized void serviceStop() throws Exception {
            if (MiniYARNCluster.this.nodeManagers[this.index] != null) {
                MiniYARNCluster.this.nodeManagers[this.index].stop();
            }
            super.serviceStop();
        }
    }

    private class ResourceManagerWrapper
    extends AbstractService {
        private int index;

        public ResourceManagerWrapper(int i) {
            super(ResourceManagerWrapper.class.getName() + "_" + i);
            this.index = i;
        }

        protected synchronized void serviceInit(Configuration conf) throws Exception {
            MiniYARNCluster.this.initResourceManager(this.index, conf);
            super.serviceInit(conf);
        }

        protected synchronized void serviceStart() throws Exception {
            MiniYARNCluster.this.startResourceManager(this.index);
            LOG.info((Object)("MiniYARN ResourceManager address: " + this.getConfig().get("yarn.resourcemanager.address")));
            LOG.info((Object)("MiniYARN ResourceManager web address: " + WebAppUtils.getRMWebAppURLWithoutScheme((Configuration)this.getConfig())));
            super.serviceStart();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForAppMastersToFinish(long timeoutMillis) throws InterruptedException {
            long started = System.currentTimeMillis();
            ConcurrentMap concurrentMap = MiniYARNCluster.this.appMasters;
            synchronized (concurrentMap) {
                while (!MiniYARNCluster.this.appMasters.isEmpty() && System.currentTimeMillis() - started < timeoutMillis) {
                    MiniYARNCluster.this.appMasters.wait(1000L);
                }
            }
            if (!MiniYARNCluster.this.appMasters.isEmpty()) {
                LOG.warn((Object)"Stopping RM while some app masters are still alive");
            }
        }

        protected synchronized void serviceStop() throws Exception {
            if (MiniYARNCluster.this.resourceManagers[this.index] != null) {
                this.waitForAppMastersToFinish(5000L);
                MiniYARNCluster.this.resourceManagers[this.index].stop();
            }
            if (Shell.WINDOWS) {
                String testWorkDirPath = MiniYARNCluster.this.testWorkDir.getAbsolutePath();
                try {
                    FileContext.getLocalFSFileContext().delete(new Path(testWorkDirPath), true);
                }
                catch (IOException e) {
                    LOG.warn((Object)("could not cleanup symlink: " + MiniYARNCluster.this.testWorkDir.getAbsolutePath()));
                }
            }
            super.serviceStop();
        }
    }
}

