/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.internal.BaseComputeService;
import org.jclouds.compute.internal.PersistNodeCredentials;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetImageStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.domain.Tag;
import org.jclouds.ec2.features.InstanceApi;
import org.jclouds.ec2.features.KeyPairApi;
import org.jclouds.ec2.features.SecurityGroupApi;
import org.jclouds.ec2.features.TagApi;
import org.jclouds.ec2.util.TagFilterBuilder;
import org.jclouds.ec2.util.Tags;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;
import org.jclouds.util.Predicates2;

@Singleton
public class EC2ComputeService
extends BaseComputeService {
    private final EC2Api client;
    private final ConcurrentMap<RegionAndName, KeyPair> credentialsMap;
    private final LoadingCache<RegionAndName, String> securityGroupMap;
    private final GroupNamingConvention.Factory namingConvention;
    private final boolean generateInstanceNames;
    private final ComputeServiceConstants.Timeouts timeouts;
    private static final Function<NodeMetadata, String> instanceId = new Function<NodeMetadata, String>(){

        public String apply(NodeMetadata in) {
            return in.getProviderId();
        }
    };
    @Inject(optional=true)
    @Named(value="jclouds.compute.resourcename-delimiter")
    char delimiter = (char)35;

    @Inject
    protected EC2ComputeService(ComputeServiceContext context, Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> sizes, @Memoized Supplier<Set<? extends Location>> locations, ListNodesStrategy listNodesStrategy, GetImageStrategy getImageStrategy, GetNodeMetadataStrategy getNodeMetadataStrategy, CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy, RebootNodeStrategy rebootNodeStrategy, DestroyNodeStrategy destroyNodeStrategy, ResumeNodeStrategy startNodeStrategy, SuspendNodeStrategy stopNodeStrategy, Provider<TemplateBuilder> templateBuilderProvider, @Named(value="DEFAULT") Provider<TemplateOptions> templateOptionsProvider, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, @Named(value="jclouds.compute.timeout.node-terminated") Predicate<AtomicReference<NodeMetadata>> nodeTerminated, @Named(value="jclouds.compute.timeout.node-suspended") Predicate<AtomicReference<NodeMetadata>> nodeSuspended, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, RunScriptOnNode.Factory runScriptOnNodeFactory, InitAdminAccess initAdminAccess, PersistNodeCredentials persistNodeCredentials, ComputeServiceConstants.Timeouts timeouts, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, EC2Api client, ConcurrentMap<RegionAndName, KeyPair> credentialsMap, @Named(value="SECURITY") LoadingCache<RegionAndName, String> securityGroupMap, Optional<ImageExtension> imageExtension, GroupNamingConvention.Factory namingConvention, @Named(value="jclouds.ec2.generate-instance-names") boolean generateInstanceNames, Optional<SecurityGroupExtension> securityGroupExtension) {
        super(context, credentialStore, images, sizes, locations, listNodesStrategy, getImageStrategy, getNodeMetadataStrategy, runNodesAndAddToSetStrategy, rebootNodeStrategy, destroyNodeStrategy, startNodeStrategy, stopNodeStrategy, templateBuilderProvider, templateOptionsProvider, nodeRunning, nodeTerminated, nodeSuspended, initScriptRunnerFactory, initAdminAccess, runScriptOnNodeFactory, persistNodeCredentials, timeouts, userExecutor, imageExtension, securityGroupExtension);
        this.client = client;
        this.credentialsMap = credentialsMap;
        this.securityGroupMap = securityGroupMap;
        this.namingConvention = namingConvention;
        this.generateInstanceNames = generateInstanceNames;
        this.timeouts = timeouts;
    }

    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count, Template template) throws RunNodesException {
        Set nodes = super.createNodesInGroup(group, count, template);
        String region = AWSUtils.getRegionFromLocationOrNull((Location)template.getLocation());
        if (this.client.getTagApiForRegion(region).isPresent()) {
            Map common = ComputeServiceUtils.metadataAndTagsAsValuesOfEmptyString((TemplateOptions)template.getOptions());
            if (this.generateInstanceNames || !common.isEmpty() || !template.getOptions().getNodeNames().isEmpty()) {
                return this.addTagsAndNamesToInstancesInRegion(common, template.getOptions().getNodeNames(), nodes, region, group);
            }
        }
        return nodes;
    }

    private Set<NodeMetadata> addTagsAndNamesToInstancesInRegion(Map<String, String> common, Set<String> nodeNames, Set<? extends NodeMetadata> input, String region, String group) {
        ImmutableMap instancesById = Maps.uniqueIndex(input, instanceId);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ArrayList namesToUse = Lists.newArrayList(nodeNames);
        if (this.generateInstanceNames && !common.containsKey("Name")) {
            for (Map.Entry entry : instancesById.entrySet()) {
                String string = (String)entry.getKey();
                String name = !namesToUse.isEmpty() ? (String)namesToUse.remove(0) : string.replaceAll(".*-", group + "-");
                ImmutableMap tags = ImmutableMap.builder().putAll(common).put((Object)"Name", (Object)name).build();
                this.logger.debug(">> applying tags %s to instance %s in region %s", new Object[]{tags, string, region});
                ((TagApi)this.client.getTagApiForRegion(region).get()).applyToResources((Map<String, String>)tags, (Iterable<String>)ImmutableSet.of((Object)string));
                builder.add((Object)EC2ComputeService.addTagsForInstance((Map<String, String>)tags, (NodeMetadata)instancesById.get(string)));
            }
        } else {
            Set<String> ids = instancesById.keySet();
            this.logger.debug(">> applying tags %s to instances %s in region %s", new Object[]{common, ids, region});
            ((TagApi)this.client.getTagApiForRegion(region).get()).applyToResources(common, ids);
            for (NodeMetadata nodeMetadata : input) {
                builder.add((Object)EC2ComputeService.addTagsForInstance(common, nodeMetadata));
            }
        }
        if (this.logger.isDebugEnabled()) {
            ImmutableMultimap filter = new TagFilterBuilder().resourceIds(instancesById.keySet()).build();
            FluentIterable<Tag> fluentIterable = ((TagApi)this.client.getTagApiForRegion(region).get()).filter((Multimap<String, String>)filter);
            this.logger.debug("<< applied tags in region %s: %s", new Object[]{region, Tags.resourceToTagsAsMap(fluentIterable)});
        }
        return builder.build();
    }

    private static NodeMetadata addTagsForInstance(Map<String, String> tags, NodeMetadata input) {
        NodeMetadataBuilder builder = NodeMetadataBuilder.fromNodeMetadata((NodeMetadata)input).name(tags.get("Name"));
        return ComputeServiceUtils.addMetadataAndParseTagsFromValuesOfEmptyString((NodeMetadataBuilder)builder, tags).build();
    }

    @VisibleForTesting
    void deleteSecurityGroup(String region, String group) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)region), (Object)"region must be defined");
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)group), (Object)"group must be defined");
        String groupName = this.namingConvention.create().sharedNameForGroup(group);
        if (!((SecurityGroupApi)this.client.getSecurityGroupApi().get()).describeSecurityGroupsInRegion(region, groupName).isEmpty()) {
            this.logger.debug(">> deleting securityGroup(%s)", new Object[]{groupName});
            ((SecurityGroupApi)this.client.getSecurityGroupApi().get()).deleteSecurityGroupInRegion(region, groupName);
            this.securityGroupMap.invalidate((Object)new RegionNameAndIngressRules(region, groupName, null, false, null));
            this.logger.debug("<< deleted securityGroup(%s)", new Object[]{groupName});
        }
    }

    @VisibleForTesting
    void deleteKeyPair(String region, String group) {
        for (KeyPair keyPair : ((KeyPairApi)this.client.getKeyPairApi().get()).describeKeyPairsInRegionWithFilter(region, (Multimap<String, String>)ImmutableMultimap.builder().put((Object)"key-name", (Object)String.format("jclouds#%s#*", group).replace('#', this.delimiter)).build())) {
            String keyName = keyPair.getKeyName();
            Predicate keyNameMatcher = this.namingConvention.create().containsGroup(group);
            String oldKeyNameRegex = String.format("jclouds#%s#%s#%s", group, region, "[0-9a-f]+").replace('#', this.delimiter);
            if (!keyNameMatcher.apply((Object)keyName) && !keyName.matches(oldKeyNameRegex)) continue;
            ImmutableSet<String> instancesUsingKeyPair = this.extractIdsFromInstances(Iterables.concat(((InstanceApi)this.client.getInstanceApi().get()).describeInstancesInRegionWithFilter(region, (Multimap<String, String>)ImmutableMultimap.builder().put((Object)"instance-state-name", (Object)InstanceState.TERMINATED.toString()).put((Object)"instance-state-name", (Object)InstanceState.SHUTTING_DOWN.toString()).put((Object)"key-name", (Object)keyPair.getKeyName()).build())));
            if (!instancesUsingKeyPair.isEmpty()) {
                this.logger.debug("<< inUse keyPair(%s), by (%s)", new Object[]{keyPair.getKeyName(), instancesUsingKeyPair});
                continue;
            }
            this.logger.debug(">> deleting keyPair(%s)", new Object[]{keyPair.getKeyName()});
            ((KeyPairApi)this.client.getKeyPairApi().get()).deleteKeyPairInRegion(region, keyPair.getKeyName());
            this.credentialsMap.remove(new RegionAndName(region, keyPair.getKeyName()));
            this.credentialsMap.remove(new RegionAndName(region, group));
            this.logger.debug("<< deleted keyPair(%s)", new Object[]{keyPair.getKeyName()});
        }
    }

    protected ImmutableSet<String> extractIdsFromInstances(Iterable<? extends RunningInstance> deadOnes) {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(deadOnes, (Function)new Function<RunningInstance, String>(){

            public String apply(RunningInstance input) {
                return input.getId();
            }
        }));
    }

    protected void cleanUpIncidentalResourcesOfDeadNodes(Set<? extends NodeMetadata> deadNodes) {
        ImmutableMultimap.Builder regionGroups = ImmutableMultimap.builder();
        for (NodeMetadata nodeMetadata : deadNodes) {
            if (nodeMetadata.getGroup() == null) continue;
            regionGroups.put((Object)AWSUtils.parseHandle((String)nodeMetadata.getId())[0], (Object)nodeMetadata.getGroup());
        }
        for (Map.Entry entry : regionGroups.build().entries()) {
            this.cleanUpIncidentalResources((String)entry.getKey(), (String)entry.getValue());
        }
    }

    protected void cleanUpIncidentalResources(String region, String group) {
        long timeout = this.timeouts.cleanupIncidentalResources;
        Predicates2.retry((Predicate)new Predicate<RegionAndName>(){

            public boolean apply(RegionAndName input) {
                try {
                    EC2ComputeService.this.logger.debug(">> deleting incidentalResources(%s)", new Object[]{input});
                    EC2ComputeService.this.deleteSecurityGroup(input.getRegion(), input.getName());
                    EC2ComputeService.this.deleteKeyPair(input.getRegion(), input.getName());
                    EC2ComputeService.this.logger.debug("<< deleted incidentalResources(%s)", new Object[]{input});
                    return true;
                }
                catch (IllegalStateException e) {
                    EC2ComputeService.this.logger.debug("<< inUse incidentalResources(%s)", new Object[]{input});
                    return false;
                }
            }
        }, (long)timeout, (long)50L, (long)1000L, (TimeUnit)TimeUnit.MILLISECONDS).apply((Object)new RegionAndName(region, group));
    }

    public EC2TemplateOptions templateOptions() {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.templateOptions());
    }
}

