/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import java.util.Map;
import javax.inject.Inject;
import org.jclouds.ec2.domain.Subnet;
import org.jclouds.ec2.xml.TagSetHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class SubnetHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Subnet> {
    private StringBuilder currentText = new StringBuilder();
    private Subnet.Builder builder = Subnet.builder();
    private final TagSetHandler tagSetHandler;
    private boolean inTagSet;

    @Inject
    public SubnetHandler(TagSetHandler tagSetHandler) {
        this.tagSetHandler = tagSetHandler;
    }

    public Subnet getResult() {
        try {
            Subnet subnet = this.builder.build();
            return subnet;
        }
        finally {
            this.builder = Subnet.builder();
        }
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"tagSet")) {
            this.inTagSet = true;
        }
        if (this.inTagSet) {
            this.tagSetHandler.startElement(uri, name, qName, attrs);
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"tagSet")) {
            this.inTagSet = false;
            this.builder.tags((Map<String, String>)this.tagSetHandler.getResult());
        } else if (this.inTagSet) {
            this.tagSetHandler.endElement(uri, name, qName);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"subnetId")) {
            this.builder.subnetId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"state")) {
            this.builder.subnetState(Subnet.State.fromValue(SaxUtils.currentOrNull((StringBuilder)this.currentText)));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"vpcId")) {
            this.builder.vpcId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"cidrBlock")) {
            this.builder.cidrBlock(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"availableIpAddressCount")) {
            this.builder.availableIpAddressCount(Integer.parseInt(SaxUtils.currentOrNull((StringBuilder)this.currentText)));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"availabilityZone")) {
            this.builder.availabilityZone(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inTagSet) {
            this.tagSetHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

