/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.domain;

import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.profitbricks.domain.IpBlock;
import org.jclouds.profitbricks.domain.Location;

final class AutoValue_IpBlock
extends IpBlock {
    private final String id;
    private final Location location;
    private final List<IpBlock.PublicIp> publicIps;
    private final List<String> ips;

    private AutoValue_IpBlock(String id, Location location, List<IpBlock.PublicIp> publicIps, @Nullable List<String> ips) {
        if (id == null) {
            throw new NullPointerException("Null id");
        }
        this.id = id;
        if (location == null) {
            throw new NullPointerException("Null location");
        }
        this.location = location;
        if (publicIps == null) {
            throw new NullPointerException("Null publicIps");
        }
        this.publicIps = publicIps;
        this.ips = ips;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Location location() {
        return this.location;
    }

    @Override
    public List<IpBlock.PublicIp> publicIps() {
        return this.publicIps;
    }

    @Override
    @Nullable
    public List<String> ips() {
        return this.ips;
    }

    public String toString() {
        return "IpBlock{id=" + this.id + ", " + "location=" + (Object)((Object)this.location) + ", " + "publicIps=" + this.publicIps + ", " + "ips=" + this.ips + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IpBlock) {
            IpBlock that = (IpBlock)o;
            return this.id.equals(that.id()) && this.location.equals((Object)that.location()) && this.publicIps.equals(that.publicIps()) && (this.ips == null ? that.ips() == null : this.ips.equals(that.ips()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.id.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.publicIps.hashCode();
        h *= 1000003;
        return h ^= this.ips == null ? 0 : this.ips.hashCode();
    }

    @Override
    public IpBlock.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends IpBlock.Builder {
        private String id;
        private Location location;
        private List<IpBlock.PublicIp> publicIps;
        private List<String> ips;

        Builder() {
        }

        Builder(IpBlock source) {
            this.id = source.id();
            this.location = source.location();
            this.publicIps = source.publicIps();
            this.ips = source.ips();
        }

        @Override
        public IpBlock.Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public IpBlock.Builder location(Location location) {
            this.location = location;
            return this;
        }

        @Override
        public IpBlock.Builder publicIps(List<IpBlock.PublicIp> publicIps) {
            this.publicIps = publicIps;
            return this;
        }

        @Override
        public IpBlock.Builder ips(List<String> ips) {
            this.ips = ips;
            return this;
        }

        @Override
        public IpBlock autoBuild() {
            String missing = "";
            if (this.id == null) {
                missing = missing + " id";
            }
            if (this.location == null) {
                missing = missing + " location";
            }
            if (this.publicIps == null) {
                missing = missing + " publicIps";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_IpBlock(this.id, this.location, this.publicIps, this.ips);
        }
    }
}

