/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http.parser.storage;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Date;
import java.util.List;
import org.jclouds.date.DateService;
import org.jclouds.profitbricks.domain.ProvisioningState;
import org.jclouds.profitbricks.domain.Storage;
import org.jclouds.profitbricks.http.parser.BaseProfitBricksResponseHandler;

public abstract class BaseStorageResponseHandler<T>
extends BaseProfitBricksResponseHandler<T> {
    protected final DateService dateService;
    protected Storage.Builder builder;
    protected List<String> serverIds;

    @Inject
    BaseStorageResponseHandler(DateService dateService) {
        this.dateService = dateService;
        this.builder = Storage.builder();
        this.serverIds = Lists.newArrayList();
    }

    protected final Date textToIso8601Date() {
        return this.dateService.iso8601DateOrSecondsDateParse(this.textToStringValue());
    }

    @Override
    protected void setPropertyOnEndTag(String qName) {
        if ("storageId".equals(qName)) {
            this.builder.id(this.textToStringValue());
        } else if ("size".equals(qName)) {
            this.builder.size(this.textToFloatValue().floatValue());
        } else if ("storageName".equals(qName)) {
            this.builder.name(this.textToStringValue());
        } else if ("provisioningState".equals(qName)) {
            this.builder.state(ProvisioningState.fromValue(this.textToStringValue()));
        } else if ("creationTime".equals(qName)) {
            this.builder.creationTime(this.textToIso8601Date());
        } else if ("lastModificationTime".equals(qName)) {
            this.builder.lastModificationTime(this.textToIso8601Date());
        } else if ("serverIds".equals(qName)) {
            this.serverIds.add(this.textToStringValue());
        } else if ("bootDevice".equals(qName)) {
            this.builder.bootDevice(this.textToBooleanValue());
        } else if ("busType".equals(qName)) {
            this.builder.busType(Storage.BusType.fromValue(this.textToStringValue()));
        } else if ("deviceNumber".equals(qName)) {
            this.builder.deviceNumber(this.textToIntValue());
        }
    }
}

