/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.bytestreamsplit;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.values.bytestreamsplit.ByteStreamSplitValuesReaderForDouble;
import org.apache.parquet.column.values.bytestreamsplit.ByteStreamSplitValuesReaderForFloat;
import org.apache.parquet.io.ParquetDecodingException;
import org.junit.Assert;
import org.junit.Test;

public class ByteStreamSplitValuesReaderTest {

    public static class DoubleTest {
        private void testReader(byte[] input, double[] values) throws IOException {
            ByteBuffer buffer = ByteBuffer.wrap(input);
            ByteBufferInputStream stream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{buffer});
            ByteStreamSplitValuesReaderForDouble reader = new ByteStreamSplitValuesReaderForDouble();
            reader.initFromPage(values.length, stream);
            for (double expectedValue : values) {
                double d = reader.readDouble();
                Assert.assertEquals((double)expectedValue, (double)d, (double)0.0);
            }
        }

        @Test
        public void testSingleElement() throws Exception {
            byte[] byteData = new byte[]{-2, -1, -1, 13, -88, 119, -46, 64};
            this.testReader(byteData, new double[]{18910.62585449218});
        }

        @Test
        public void testSmallBuffer() throws Exception {
            byte[] byteData = new byte[]{-25, 114, -66, 9, -95, -63, 10, 10, 23, -41, 33, 38, 1, -57, 83, 10, 70, 5, 112, -13, -28, 64, -64, 63};
            double[] expectedValues = new double[]{256.625449218, -78956.4455667788, 0.62565};
            this.testReader(byteData, expectedValues);
        }

        @Test
        public void testRandomInput() throws Exception {
            Random rand = new Random(6557L);
            int numElements = 256;
            byte[] byteData = new byte[2048];
            double[] values = new double[256];
            for (int i = 0; i < 256; ++i) {
                double f;
                values[i] = f = rand.nextDouble() * 8192.0;
                long fAsLong = Double.doubleToLongBits(f);
                for (int j = 0; j < 8; ++j) {
                    byteData[256 * j + i] = (byte)(fAsLong >> 8 * j & 0xFFL);
                }
            }
            this.testReader(byteData, values);
        }
    }

    public static class FloatTest {
        private void testReader(byte[] input, float[] values) throws IOException {
            ByteBuffer buffer = ByteBuffer.wrap(input);
            ByteBufferInputStream stream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{buffer});
            ByteStreamSplitValuesReaderForFloat reader = new ByteStreamSplitValuesReaderForFloat();
            reader.initFromPage(values.length, stream);
            for (float expectedValue : values) {
                float f = reader.readFloat();
                Assert.assertEquals((float)expectedValue, (float)f, (float)0.0f);
            }
        }

        @Test
        public void testSingleElement() throws Exception {
            byte[] byteData = new byte[]{0, 0, 16, 64};
            this.testReader(byteData, new float[]{2.25f});
        }

        @Test
        public void testSmallBuffer() throws Exception {
            byte[] byteData = new byte[]{64, 0, -128, 64, 5, -124, -59, -67, 50, -62, 65, 66};
            float[] expectedValues = new float[]{-98.62549f, 23.627441f, 44.629395f};
            this.testReader(byteData, expectedValues);
        }

        @Test
        public void testRandomInput() throws Exception {
            Random rand = new Random(1337L);
            int numElements = 256;
            byte[] byteData = new byte[1024];
            float[] values = new float[256];
            for (int i = 0; i < 256; ++i) {
                float f;
                values[i] = f = rand.nextFloat() * 1024.0f;
                int fAsInt = Float.floatToIntBits(f);
                byteData[i] = (byte)(fAsInt & 0xFF);
                byteData[256 + i] = (byte)(fAsInt >> 8 & 0xFF);
                byteData[512 + i] = (byte)(fAsInt >> 16 & 0xFF);
                byteData[768 + i] = (byte)(fAsInt >> 24 & 0xFF);
            }
            this.testReader(byteData, values);
        }

        @Test
        public void testExtraReads() throws Exception {
            byte[] byteData = new byte[]{0, 0, 16, 64};
            ByteBuffer buffer = ByteBuffer.wrap(byteData);
            ByteBufferInputStream stream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{buffer});
            ByteStreamSplitValuesReaderForFloat reader = new ByteStreamSplitValuesReaderForFloat();
            reader.initFromPage(1, stream);
            float f = reader.readFloat();
            Assert.assertEquals((float)2.25f, (float)f, (float)0.0f);
            try {
                reader.readFloat();
                Assert.fail((String)"Expected an exception.");
            }
            catch (ParquetDecodingException parquetDecodingException) {
                // empty catch block
            }
        }

        @Test
        public void testSkip() throws Exception {
            byte[] byteData = new byte[16];
            for (int i = 0; i < 16; ++i) {
                byteData[i] = -1;
            }
            byteData[3] = 0;
            byteData[7] = 0;
            byteData[11] = 16;
            byteData[15] = 64;
            ByteBuffer buffer = ByteBuffer.wrap(byteData);
            ByteBufferInputStream stream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{buffer});
            ByteStreamSplitValuesReaderForFloat reader = new ByteStreamSplitValuesReaderForFloat();
            reader.initFromPage(4, stream);
            reader.skip(3);
            float f = reader.readFloat();
            Assert.assertEquals((float)2.25f, (float)f, (float)0.0f);
        }

        @Test
        public void testSkipOverflow() throws Exception {
            byte[] byteData = new byte[128];
            ByteBuffer buffer = ByteBuffer.wrap(byteData);
            ByteBufferInputStream stream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{buffer});
            ByteStreamSplitValuesReaderForFloat reader = new ByteStreamSplitValuesReaderForFloat();
            reader.initFromPage(32, stream);
            try {
                reader.skip(33);
                Assert.fail((String)"Expected an exception.");
            }
            catch (ParquetDecodingException parquetDecodingException) {
                // empty catch block
            }
        }

        @Test
        public void testSkipUnderflow() throws Exception {
            byte[] byteData = new byte[128];
            ByteBuffer buffer = ByteBuffer.wrap(byteData);
            ByteBufferInputStream stream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{buffer});
            ByteStreamSplitValuesReaderForFloat reader = new ByteStreamSplitValuesReaderForFloat();
            reader.initFromPage(32, stream);
            try {
                reader.skip(-1);
                Assert.fail((String)"Expected an exception.");
            }
            catch (ParquetDecodingException parquetDecodingException) {
                // empty catch block
            }
        }
    }
}

