/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.io;

import org.apache.parquet.column.ColumnWriteStore;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.impl.ColumnWriteStoreV1;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageWriteStore;
import org.apache.parquet.column.page.mem.MemPageStore;
import org.apache.parquet.example.DummyRecordConverter;
import org.apache.parquet.example.Paper;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.GroupWriter;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;

public class PerfTest {
    public static void main(String[] args) {
        MemPageStore memPageStore = new MemPageStore(0L);
        PerfTest.write(memPageStore);
        PerfTest.read(memPageStore);
    }

    private static void read(MemPageStore memPageStore) {
        PerfTest.read(memPageStore, Paper.schema, "read all");
        PerfTest.read(memPageStore, Paper.schema, "read all");
        PerfTest.read(memPageStore, Paper.schema2, "read projected");
        PerfTest.read(memPageStore, Paper.schema3, "read projected no Strings");
    }

    private static void read(MemPageStore memPageStore, MessageType myschema, String message) {
        MessageColumnIO columnIO = PerfTest.newColumnFactory(myschema);
        System.out.println(message);
        DummyRecordConverter recordConsumer = new DummyRecordConverter(myschema);
        RecordReader recordReader = columnIO.getRecordReader((PageReadStore)memPageStore, (RecordMaterializer)recordConsumer);
        PerfTest.read((RecordReader<Object>)recordReader, 2, myschema);
        PerfTest.read((RecordReader<Object>)recordReader, 10000, myschema);
        PerfTest.read((RecordReader<Object>)recordReader, 10000, myschema);
        PerfTest.read((RecordReader<Object>)recordReader, 10000, myschema);
        PerfTest.read((RecordReader<Object>)recordReader, 10000, myschema);
        PerfTest.read((RecordReader<Object>)recordReader, 10000, myschema);
        PerfTest.read((RecordReader<Object>)recordReader, 100000, myschema);
        PerfTest.read((RecordReader<Object>)recordReader, 1000000, myschema);
        System.out.println();
    }

    private static void write(MemPageStore memPageStore) {
        ColumnWriteStoreV1 columns = new ColumnWriteStoreV1((PageWriteStore)memPageStore, ParquetProperties.builder().withPageSize(0x3200000).withDictionaryEncoding(false).build());
        MessageColumnIO columnIO = PerfTest.newColumnFactory(Paper.schema);
        GroupWriter groupWriter = new GroupWriter(columnIO.getRecordWriter((ColumnWriteStore)columns), (GroupType)Paper.schema);
        groupWriter.write((Group)Paper.r1);
        groupWriter.write((Group)Paper.r2);
        PerfTest.write(memPageStore, groupWriter, 10000);
        PerfTest.write(memPageStore, groupWriter, 10000);
        PerfTest.write(memPageStore, groupWriter, 10000);
        PerfTest.write(memPageStore, groupWriter, 10000);
        PerfTest.write(memPageStore, groupWriter, 10000);
        PerfTest.write(memPageStore, groupWriter, 100000);
        PerfTest.write(memPageStore, groupWriter, 1000000);
        columns.flush();
        System.out.println();
        System.out.println(columns.getBufferedSize() + " bytes used total");
        System.out.println("max col size: " + columns.maxColMemSize() + " bytes");
    }

    private static MessageColumnIO newColumnFactory(MessageType schema) {
        return new ColumnIOFactory().getColumnIO(schema);
    }

    private static void read(RecordReader<Object> recordReader, int count, MessageType schema) {
        Object[] records = new Object[count];
        System.gc();
        System.out.print("no gc <");
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < records.length; ++i) {
            records[i] = recordReader.read();
        }
        long t1 = System.currentTimeMillis();
        System.out.print("> ");
        long t = t1 - t0;
        float err = 200.0f / (float)t;
        System.out.printf("                                            read %,9d recs in %,5d ms at %,9d rec/s err: %3.2f%%\n", count, t, t == 0L ? 0L : (long)(count * 1000) / t, Float.valueOf(err));
        if (!records[0].equals("end()")) {
            throw new RuntimeException("" + records[0]);
        }
    }

    private static void write(MemPageStore memPageStore, GroupWriter groupWriter, int count) {
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            groupWriter.write((Group)Paper.r1);
        }
        long t1 = System.currentTimeMillis();
        long t = t1 - t0;
        memPageStore.addRowCount(count);
        System.out.printf("written %,9d recs in %,5d ms at %,9d rec/s\n", count, t, t == 0L ? 0L : (long)(count * 1000) / t);
    }
}

