/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import org.apache.parquet.example.Paper;
import org.apache.parquet.schema.ColumnOrder;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.IncompatibleSchemaModificationException;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestMessageType {
    @Test
    public void test() throws Exception {
        MessageType schema = MessageTypeParser.parseMessageType((String)Paper.schema.toString());
        Assert.assertEquals((Object)Paper.schema, (Object)schema);
        Assert.assertEquals((Object)schema.toString(), (Object)Paper.schema.toString());
    }

    @Test
    public void testNestedTypes() {
        MessageType schema = MessageTypeParser.parseMessageType((String)Paper.schema.toString());
        Type type = schema.getType(new String[]{"Links", "Backward"});
        Assert.assertEquals((Object)PrimitiveType.PrimitiveTypeName.INT64, (Object)type.asPrimitiveType().getPrimitiveTypeName());
        Assert.assertEquals((long)0L, (long)schema.getMaxRepetitionLevel(new String[]{"DocId"}));
        Assert.assertEquals((long)1L, (long)schema.getMaxRepetitionLevel(new String[]{"Name"}));
        Assert.assertEquals((long)2L, (long)schema.getMaxRepetitionLevel(new String[]{"Name", "Language"}));
        Assert.assertEquals((long)0L, (long)schema.getMaxDefinitionLevel(new String[]{"DocId"}));
        Assert.assertEquals((long)1L, (long)schema.getMaxDefinitionLevel(new String[]{"Links"}));
        Assert.assertEquals((long)2L, (long)schema.getMaxDefinitionLevel(new String[]{"Links", "Backward"}));
    }

    @Test
    public void testMergeSchema() {
        MessageType t1 = new MessageType("root1", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b")});
        MessageType t2 = new MessageType("root2", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "c")});
        Assert.assertEquals((Object)t1.union(t2), (Object)new MessageType("root1", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "c")}));
        Assert.assertEquals((Object)t2.union(t1), (Object)new MessageType("root2", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "c"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b")}));
        MessageType t3 = new MessageType("root1", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "a")});
        MessageType t4 = new MessageType("root2", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "a")});
        Assert.assertEquals((Object)t3.union(t4), (Object)new MessageType("root1", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "a")}));
        Assert.assertEquals((Object)t4.union(t3), (Object)new MessageType("root2", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "a")}));
        MessageType t5 = new MessageType("root1", new Type[]{new GroupType(Type.Repetition.REQUIRED, "g1", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "a")}), new GroupType(Type.Repetition.REQUIRED, "g2", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b")})});
        MessageType t6 = new MessageType("root1", new Type[]{new GroupType(Type.Repetition.REQUIRED, "g1", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "a")}), new GroupType(Type.Repetition.REQUIRED, "g2", new Type[]{new GroupType(Type.Repetition.REQUIRED, "g3", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "c")}), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b")})});
        Assert.assertEquals((Object)t5.union(t6), (Object)new MessageType("root1", new Type[]{new GroupType(Type.Repetition.REQUIRED, "g1", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "a")}), new GroupType(Type.Repetition.REQUIRED, "g2", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b"), new GroupType(Type.Repetition.REQUIRED, "g3", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "c")})})}));
        MessageType t7 = new MessageType("root1", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "a")});
        MessageType t8 = new MessageType("root2", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "a")});
        try {
            t7.union(t8);
            Assert.fail((String)"moving from BINARY to INT32");
        }
        catch (IncompatibleSchemaModificationException e) {
            Assert.assertEquals((Object)"can not merge type optional int32 a into optional binary a", (Object)e.getMessage());
        }
        MessageType t9 = (MessageType)((Types.GroupBuilder)Types.buildMessage().addField((Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("a"))).named("root1");
        MessageType t10 = (MessageType)((Types.GroupBuilder)Types.buildMessage().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("a"))).named("root1");
        Assert.assertEquals((Object)t9.union(t9), (Object)t9);
        try {
            t9.union(t10);
            Assert.fail((String)"moving from BINARY (UTF8) to BINARY");
        }
        catch (IncompatibleSchemaModificationException e) {
            Assert.assertEquals((Object)"cannot merge logical type null into STRING", (Object)e.getMessage());
        }
        MessageType t11 = (MessageType)((Types.GroupBuilder)Types.buildMessage().addField((Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(10)).named("a"))).named("root1");
        MessageType t12 = (MessageType)((Types.GroupBuilder)Types.buildMessage().addField((Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(20)).named("a"))).named("root2");
        try {
            t11.union(t12);
            Assert.fail((String)"moving from FIXED_LEN_BYTE_ARRAY(10) to FIXED_LEN_BYTE_ARRAY(20)");
        }
        catch (IncompatibleSchemaModificationException e) {
            Assert.assertEquals((Object)"can not merge type optional fixed_len_byte_array(20) a into optional fixed_len_byte_array(10) a", (Object)e.getMessage());
        }
    }

    @Test
    public void testMergeSchemaWithOriginalType() throws Exception {
        MessageType t5 = new MessageType("root1", new Type[]{new GroupType(Type.Repetition.REQUIRED, "g1", OriginalType.LIST, new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "a")}), new GroupType(Type.Repetition.REQUIRED, "g2", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b")})});
        MessageType t6 = new MessageType("root1", new Type[]{new GroupType(Type.Repetition.REQUIRED, "g1", OriginalType.LIST, new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "a")}), new GroupType(Type.Repetition.REQUIRED, "g2", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REQUIRED, "g3", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "c")}), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b")})});
        Assert.assertEquals((Object)new MessageType("root1", new Type[]{new GroupType(Type.Repetition.REQUIRED, "g1", OriginalType.LIST, new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "a")}), new GroupType(Type.Repetition.REQUIRED, "g2", OriginalType.LIST, new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b"), new GroupType(Type.Repetition.REQUIRED, "g3", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "c")})})}), (Object)t5.union(t6));
    }

    @Test
    public void testMergeSchemaWithColumnOrder() {
        MessageType m1 = (MessageType)((Types.GroupBuilder)Types.buildMessage().addFields(new Type[]{(Type)Types.requiredList().element((Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).columnOrder(ColumnOrder.undefined())).named("a")).named("g"), (Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96).named("b")})).named("root");
        MessageType m2 = (MessageType)((Types.GroupBuilder)Types.buildMessage().addFields(new Type[]{(Type)Types.requiredList().element((Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).columnOrder(ColumnOrder.undefined())).named("a")).named("g"), (Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("c")})).named("root");
        MessageType m3 = (MessageType)((Types.GroupBuilder)Types.buildMessage().addFields(new Type[]{(Type)Types.requiredList().element((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("a")).named("g")})).named("root");
        Assert.assertEquals((Object)((Types.GroupBuilder)Types.buildMessage().addFields(new Type[]{(Type)Types.requiredList().element((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("a")).named("g"), (Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96).named("b"), (Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("c")})).named("root"), (Object)m1.union(m2));
        try {
            m1.union(m3);
            Assert.fail((String)"An IncompatibleSchemaModificationException should have been thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((String)("The thrown exception should have been IncompatibleSchemaModificationException but was " + e.getClass()), (boolean)(e instanceof IncompatibleSchemaModificationException));
            Assert.assertEquals((Object)"can not merge type optional binary a with column order TYPE_DEFINED_ORDER into optional binary a with column order UNDEFINED", (Object)e.getMessage());
        }
    }

    @Test
    public void testIDs() throws Exception {
        MessageType schema = new MessageType("test", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "foo").withId(4), new GroupType(Type.Repetition.REQUIRED, "bar", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "baz").withId(3)}).withId(8)});
        MessageType schema2 = MessageTypeParser.parseMessageType((String)schema.toString());
        Assert.assertEquals((Object)schema, (Object)schema2);
        Assert.assertEquals((Object)schema.toString(), (Object)schema2.toString());
    }
}

