/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.AbstractBaseDispatcher;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.HashRangeExclusiveStickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.StickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDispatcherSingleActiveConsumer
extends AbstractBaseDispatcher {
    protected final String topicName;
    protected static final AtomicReferenceFieldUpdater<AbstractDispatcherSingleActiveConsumer, Consumer> ACTIVE_CONSUMER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AbstractDispatcherSingleActiveConsumer.class, Consumer.class, "activeConsumer");
    private volatile Consumer activeConsumer = null;
    protected final CopyOnWriteArrayList<Consumer> consumers;
    protected StickyKeyConsumerSelector stickyKeyConsumerSelector;
    protected boolean isKeyHashRangeFiltered = false;
    protected CompletableFuture<Void> closeFuture = null;
    protected final int partitionIndex;
    protected final ManagedCursor cursor;
    protected final CommandSubscribe.SubType subscriptionType;
    protected static final int FALSE = 0;
    protected static final int TRUE = 1;
    protected static final AtomicIntegerFieldUpdater<AbstractDispatcherSingleActiveConsumer> IS_CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractDispatcherSingleActiveConsumer.class, "isClosed");
    private volatile int isClosed = 0;
    protected boolean isFirstRead = true;
    private static final Logger log = LoggerFactory.getLogger(AbstractDispatcherSingleActiveConsumer.class);

    public AbstractDispatcherSingleActiveConsumer(CommandSubscribe.SubType subscriptionType, int partitionIndex, String topicName, Subscription subscription, ServiceConfiguration serviceConfig, ManagedCursor cursor) {
        super(subscription, serviceConfig);
        this.topicName = topicName;
        this.consumers = new CopyOnWriteArrayList();
        this.partitionIndex = partitionIndex;
        this.subscriptionType = subscriptionType;
        this.cursor = cursor;
        ACTIVE_CONSUMER_UPDATER.set(this, null);
    }

    protected abstract void scheduleReadOnActiveConsumer();

    protected abstract void readMoreEntries(Consumer var1);

    protected abstract void cancelPendingRead();

    protected void notifyActiveConsumerChanged(Consumer activeConsumer) {
        if (null != activeConsumer && this.subscriptionType == CommandSubscribe.SubType.Failover) {
            this.consumers.forEach(consumer -> consumer.notifyActiveConsumerChange(activeConsumer));
        }
    }

    protected boolean pickAndScheduleActiveConsumer() {
        Consumer activeConsumer;
        Consumer prevConsumer;
        Preconditions.checkArgument((!this.consumers.isEmpty() ? 1 : 0) != 0);
        int index = 0;
        if (this.partitionIndex >= 0) {
            AtomicBoolean hasPriorityConsumer = new AtomicBoolean(false);
            this.consumers.sort((c1, c2) -> {
                int priority = c1.getPriorityLevel() - c2.getPriorityLevel();
                if (priority != 0) {
                    hasPriorityConsumer.set(true);
                    return priority;
                }
                return c1.consumerName().compareTo(c2.consumerName());
            });
            int consumersSize = this.consumers.size();
            if (hasPriorityConsumer.get()) {
                int highestPriorityLevel = this.consumers.get(0).getPriorityLevel();
                for (int i = 0; i < this.consumers.size(); ++i) {
                    if (highestPriorityLevel == this.consumers.get(i).getPriorityLevel()) continue;
                    consumersSize = i;
                    break;
                }
            }
            index = this.partitionIndex % consumersSize;
        }
        if ((prevConsumer = ACTIVE_CONSUMER_UPDATER.getAndSet(this, this.consumers.get(index))) == (activeConsumer = ACTIVE_CONSUMER_UPDATER.get(this))) {
            return false;
        }
        this.scheduleReadOnActiveConsumer();
        return true;
    }

    @Override
    public synchronized void addConsumer(Consumer consumer) throws BrokerServiceException {
        if (IS_CLOSED_UPDATER.get(this) == 1) {
            log.warn("[{}] Dispatcher is already closed. Closing consumer {}", (Object)this.topicName, (Object)consumer);
            consumer.disconnect();
        }
        if (this.subscriptionType == CommandSubscribe.SubType.Exclusive && !this.consumers.isEmpty()) {
            throw new BrokerServiceException.ConsumerBusyException("Exclusive consumer is already connected");
        }
        if (this.subscriptionType == CommandSubscribe.SubType.Failover && this.isConsumersExceededOnSubscription()) {
            log.warn("[{}] Attempting to add consumer to subscription which reached max consumers limit", (Object)this.topicName);
            throw new BrokerServiceException.ConsumerBusyException("Subscription reached max consumers limit");
        }
        if (this.subscriptionType == CommandSubscribe.SubType.Exclusive && consumer.getKeySharedMeta() != null && consumer.getKeySharedMeta().getHashRangesList() != null && consumer.getKeySharedMeta().getHashRangesList().size() > 0) {
            this.stickyKeyConsumerSelector = new HashRangeExclusiveStickyKeyConsumerSelector();
            this.stickyKeyConsumerSelector.addConsumer(consumer);
            this.isKeyHashRangeFiltered = true;
        } else {
            this.isKeyHashRangeFiltered = false;
        }
        if (this.consumers.isEmpty()) {
            this.isFirstRead = true;
        }
        this.consumers.add(consumer);
        if (!this.pickAndScheduleActiveConsumer()) {
            Consumer currentActiveConsumer = ACTIVE_CONSUMER_UPDATER.get(this);
            if (null == currentActiveConsumer) {
                if (log.isDebugEnabled()) {
                    log.debug("Current active consumer disappears while adding consumer {}", (Object)consumer);
                }
            } else {
                consumer.notifyActiveConsumerChange(currentActiveConsumer);
            }
        }
    }

    @Override
    public synchronized void removeConsumer(Consumer consumer) throws BrokerServiceException {
        log.info("Removing consumer {}", (Object)consumer);
        if (!this.consumers.remove(consumer)) {
            throw new BrokerServiceException.ServerMetadataException("Consumer was not connected");
        }
        if (this.consumers.isEmpty()) {
            ACTIVE_CONSUMER_UPDATER.set(this, null);
        }
        if (this.closeFuture == null && !this.consumers.isEmpty()) {
            this.pickAndScheduleActiveConsumer();
            return;
        }
        this.cancelPendingRead();
        if (this.consumers.isEmpty() && this.closeFuture != null && !this.closeFuture.isDone()) {
            this.closeFuture.complete(null);
        }
    }

    @Override
    public synchronized boolean canUnsubscribe(Consumer consumer) {
        return this.consumers.size() == 1 && Objects.equals(consumer, ACTIVE_CONSUMER_UPDATER.get(this));
    }

    @Override
    public CompletableFuture<Void> close() {
        IS_CLOSED_UPDATER.set(this, 1);
        return this.disconnectAllConsumers();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed == 1;
    }

    @Override
    public synchronized CompletableFuture<Void> disconnectAllConsumers(boolean isResetCursor) {
        this.closeFuture = new CompletableFuture();
        if (!this.consumers.isEmpty()) {
            this.consumers.forEach(consumer -> consumer.disconnect(isResetCursor));
            this.cancelPendingRead();
        } else {
            this.closeFuture.complete(null);
        }
        return this.closeFuture;
    }

    @Override
    public synchronized CompletableFuture<Void> disconnectActiveConsumers(boolean isResetCursor) {
        this.closeFuture = new CompletableFuture();
        if (this.activeConsumer != null) {
            this.activeConsumer.disconnect(isResetCursor);
        }
        this.closeFuture.complete(null);
        return this.closeFuture;
    }

    @Override
    public synchronized void resetCloseFuture() {
        this.closeFuture = null;
    }

    @Override
    public void reset() {
        this.resetCloseFuture();
        IS_CLOSED_UPDATER.set(this, 0);
    }

    @Override
    public CommandSubscribe.SubType getType() {
        return this.subscriptionType;
    }

    public Consumer getActiveConsumer() {
        return ACTIVE_CONSUMER_UPDATER.get(this);
    }

    @Override
    public List<Consumer> getConsumers() {
        return this.consumers;
    }

    @Override
    public boolean isConsumerConnected() {
        return ACTIVE_CONSUMER_UPDATER.get(this) != null;
    }
}

