/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.internal.PlatformDependent;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.bookkeeper.stats.NullStatsProvider;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.stats.metrics.ManagedCursorMetrics;
import org.apache.pulsar.broker.stats.metrics.ManagedLedgerCacheMetrics;
import org.apache.pulsar.broker.stats.metrics.ManagedLedgerMetrics;
import org.apache.pulsar.broker.stats.prometheus.NamespaceStatsAggregator;
import org.apache.pulsar.broker.stats.prometheus.PrometheusMetricsGeneratorUtils;
import org.apache.pulsar.broker.stats.prometheus.PrometheusRawMetricsProvider;
import org.apache.pulsar.broker.stats.prometheus.TransactionAggregator;
import org.apache.pulsar.common.stats.JvmMetrics;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.common.util.SimpleTextOutputStream;

public class PrometheusMetricsGenerator {
    public static void generate(PulsarService pulsar, boolean includeTopicMetrics, boolean includeConsumerMetrics, boolean includeProducerMetrics, OutputStream out) throws IOException {
        PrometheusMetricsGenerator.generate(pulsar, includeTopicMetrics, includeConsumerMetrics, includeProducerMetrics, false, out, null);
    }

    public static void generate(PulsarService pulsar, boolean includeTopicMetrics, boolean includeConsumerMetrics, boolean includeProducerMetrics, boolean splitTopicAndPartitionIndexLabel, OutputStream out) throws IOException {
        PrometheusMetricsGenerator.generate(pulsar, includeTopicMetrics, includeConsumerMetrics, includeProducerMetrics, splitTopicAndPartitionIndexLabel, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(PulsarService pulsar, boolean includeTopicMetrics, boolean includeConsumerMetrics, boolean includeProducerMetrics, boolean splitTopicAndPartitionIndexLabel, OutputStream out, List<PrometheusRawMetricsProvider> metricsProviders) throws IOException {
        ByteBuf buf = ByteBufAllocator.DEFAULT.heapBuffer();
        try {
            SimpleTextOutputStream stream = new SimpleTextOutputStream(buf);
            PrometheusMetricsGeneratorUtils.generateSystemMetrics((SimpleTextOutputStream)stream, (String)pulsar.getConfiguration().getClusterName());
            NamespaceStatsAggregator.generate(pulsar, includeTopicMetrics, includeConsumerMetrics, includeProducerMetrics, splitTopicAndPartitionIndexLabel, stream);
            if (pulsar.getWorkerServiceOpt().isPresent()) {
                pulsar.getWorkerService().generateFunctionsStats(stream);
            }
            if (pulsar.getConfiguration().isTransactionCoordinatorEnabled()) {
                TransactionAggregator.generate(pulsar, stream, includeTopicMetrics);
            }
            PrometheusMetricsGenerator.generateBrokerBasicMetrics(pulsar, stream);
            PrometheusMetricsGenerator.generateManagedLedgerBookieClientMetrics(pulsar, stream);
            if (metricsProviders != null) {
                for (PrometheusRawMetricsProvider metricsProvider : metricsProviders) {
                    metricsProvider.generate(stream);
                }
            }
            out.write(buf.array(), buf.arrayOffset(), buf.readableBytes());
        }
        finally {
            buf.release();
        }
    }

    private static void generateBrokerBasicMetrics(PulsarService pulsar, SimpleTextOutputStream stream) {
        String clusterName = pulsar.getConfiguration().getClusterName();
        PrometheusMetricsGenerator.parseMetricsToPrometheusMetrics(new ManagedLedgerCacheMetrics(pulsar).generate(), clusterName, Collector.Type.GAUGE, stream);
        if (pulsar.getConfiguration().isExposeManagedLedgerMetricsInPrometheus()) {
            PrometheusMetricsGenerator.parseMetricsToPrometheusMetrics(new ManagedLedgerMetrics(pulsar).generate(), clusterName, Collector.Type.GAUGE, stream);
        }
        if (pulsar.getConfiguration().isExposeManagedCursorMetricsInPrometheus()) {
            PrometheusMetricsGenerator.parseMetricsToPrometheusMetrics(new ManagedCursorMetrics(pulsar).generate(), clusterName, Collector.Type.GAUGE, stream);
        }
        PrometheusMetricsGenerator.parseMetricsToPrometheusMetrics(Collections.singletonList(pulsar.getBrokerService().getPulsarStats().getBrokerOperabilityMetrics().generateConnectionMetrics()), clusterName, Collector.Type.GAUGE, stream);
        PrometheusMetricsGenerator.parseMetricsToPrometheusMetrics(pulsar.getLoadManager().get().getLoadBalancingMetrics(), clusterName, Collector.Type.GAUGE, stream);
    }

    private static void parseMetricsToPrometheusMetrics(Collection<Metrics> metrics, String cluster, Collector.Type metricType, SimpleTextOutputStream stream) {
        HashSet<String> names = new HashSet<String>();
        for (Metrics metrics1 : metrics) {
            for (Map.Entry entry : metrics1.getMetrics().entrySet()) {
                String value;
                block8: {
                    value = null;
                    if (((String)entry.getKey()).contains(".")) {
                        try {
                            String key = (String)entry.getKey();
                            int dotIndex = key.indexOf(".");
                            int nameIndex = key.substring(0, dotIndex).lastIndexOf("_");
                            if (nameIndex == -1) continue;
                            String name = key.substring(0, nameIndex);
                            value = key.substring(nameIndex + 1);
                            if (!names.contains(name)) {
                                stream.write("# TYPE ").write(name.replace("brk_", "pulsar_")).write(' ').write(PrometheusMetricsGeneratorUtils.getTypeStr((Collector.Type)metricType)).write("\n");
                                names.add(name);
                            }
                            stream.write(name.replace("brk_", "pulsar_")).write("{cluster=\"").write(cluster).write('\"');
                            break block8;
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    String name = (String)entry.getKey();
                    if (!names.contains(name)) {
                        stream.write("# TYPE ").write(((String)entry.getKey()).replace("brk_", "pulsar_")).write(' ').write(PrometheusMetricsGeneratorUtils.getTypeStr((Collector.Type)metricType)).write('\n');
                        names.add(name);
                    }
                    stream.write(name.replace("brk_", "pulsar_")).write("{cluster=\"").write(cluster).write('\"');
                }
                for (Map.Entry metric : metrics1.getDimensions().entrySet()) {
                    if (((String)metric.getKey()).isEmpty() || "cluster".equals(metric.getKey())) continue;
                    stream.write(", ").write((String)metric.getKey()).write("=\"").write((String)metric.getValue()).write('\"');
                    if (value == null || value.isEmpty()) continue;
                    stream.write(", ").write("quantile=\"").write(value).write('\"');
                }
                stream.write("} ").write(String.valueOf(entry.getValue())).write(' ').write(System.currentTimeMillis()).write("\n");
            }
        }
    }

    private static void generateManagedLedgerBookieClientMetrics(PulsarService pulsar, SimpleTextOutputStream stream) {
        StatsProvider statsProvider = pulsar.getManagedLedgerClientFactory().getStatsProvider();
        if (statsProvider instanceof NullStatsProvider) {
            return;
        }
        try {
            StringWriter writer = new StringWriter();
            statsProvider.writeAllMetrics((Writer)writer);
            stream.write(((Object)writer).toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        DefaultExports.initialize();
        Gauge.build((String)"jvm_memory_direct_bytes_used", (String)"-").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return JvmMetrics.getJvmDirectMemoryUsed();
            }
        }, new String[0]).register(CollectorRegistry.defaultRegistry);
        Gauge.build((String)"jvm_memory_direct_bytes_max", (String)"-").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return PlatformDependent.maxDirectMemory();
            }
        }, new String[0]).register(CollectorRegistry.defaultRegistry);
        ((Gauge.Builder)Gauge.build((String)"pulsar_version_info", (String)"-").labelNames(new String[]{"version", "commit"})).create().setChild((Object)new Gauge.Child(){

            public double get() {
                return 1.0;
            }
        }, new String[]{PulsarVersion.getVersion(), PulsarVersion.getGitSha()}).register(CollectorRegistry.defaultRegistry);
    }
}

