/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus.metrics;

import io.prometheus.client.Collector;
import io.prometheus.client.SimpleCollector;
import io.prometheus.client.SummaryMetricFamily;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.stats.prometheus.metrics.DataSketchesSummaryLogger;

public class Summary
extends SimpleCollector<Child>
implements Collector.Describable {
    private static final List<DataSketchesSummaryLogger> LOGGERS = new ArrayList<DataSketchesSummaryLogger>();
    private final List<Double> quantiles;

    public static Builder build(String name, String help) {
        return (Builder)((Builder)Summary.build().name(name)).help(help);
    }

    public static Builder build() {
        return new Builder();
    }

    private Summary(Builder builder) {
        super((SimpleCollector.Builder)builder);
        this.quantiles = builder.quantiles;
        this.clear();
    }

    protected Child newChild() {
        if (this.quantiles != null) {
            return new Child(this.quantiles);
        }
        return new Child(Collections.emptyList());
    }

    public void observe(long eventLatency, TimeUnit unit) {
        ((Child)this.noLabelsChild).observe(eventLatency, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rotateLatencyCollection() {
        List<DataSketchesSummaryLogger> list = LOGGERS;
        synchronized (list) {
            int n = LOGGERS.size();
            for (int i = 0; i < n; ++i) {
                LOGGERS.get(i).rotateLatencyCollection();
            }
        }
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        for (Map.Entry c : this.children.entrySet()) {
            Child child = (Child)c.getValue();
            ArrayList<String> labelNamesWithQuantile = new ArrayList<String>(this.labelNames);
            labelNamesWithQuantile.add("quantile");
            for (Double q : child.quantiles) {
                ArrayList<String> labelValuesWithQuantile = new ArrayList<String>((Collection)c.getKey());
                labelValuesWithQuantile.add(Summary.doubleToGoString((double)q));
                samples.add(new Collector.MetricFamilySamples.Sample(this.fullname, labelNamesWithQuantile, labelValuesWithQuantile, child.logger.getQuantileValue(q)));
            }
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname + "_count", this.labelNames, (List)c.getKey(), (double)child.logger.getCount()));
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname + "_sum", this.labelNames, (List)c.getKey(), (double)child.logger.getSum()));
        }
        return this.familySamplesList(Collector.Type.SUMMARY, samples);
    }

    public List<Collector.MetricFamilySamples> describe() {
        return Collections.singletonList(new SummaryMetricFamily(this.fullname, this.help, this.labelNames));
    }

    public static class Builder
    extends SimpleCollector.Builder<Builder, Summary> {
        private final List<Double> quantiles = new ArrayList<Double>();

        public Builder quantile(double quantile) {
            this.quantiles.add(quantile);
            return this;
        }

        public Summary create() {
            return new Summary(this);
        }
    }

    static class Child {
        private final DataSketchesSummaryLogger logger;
        private final List<Double> quantiles;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Child(List<Double> quantiles) {
            this.quantiles = quantiles;
            this.logger = new DataSketchesSummaryLogger();
            List list = LOGGERS;
            synchronized (list) {
                if (!quantiles.isEmpty()) {
                    LOGGERS.add(this.logger);
                }
            }
        }

        public void observe(long eventLatency, TimeUnit unit) {
            this.logger.registerEvent(eventLatency, unit);
        }
    }
}

