/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.RangeEquallyDivideBundleSplitAlgorithm;
import org.apache.pulsar.common.naming.TopicCountEquallyDivideBundleSplitAlgorithm;

public interface NamespaceBundleSplitAlgorithm {
    public static final String RANGE_EQUALLY_DIVIDE_NAME = "range_equally_divide";
    public static final String TOPIC_COUNT_EQUALLY_DIVIDE = "topic_count_equally_divide";
    public static final List<String> AVAILABLE_ALGORITHMS = Lists.newArrayList((Object[])new String[]{"range_equally_divide", "topic_count_equally_divide"});
    public static final NamespaceBundleSplitAlgorithm RANGE_EQUALLY_DIVIDE_ALGO = new RangeEquallyDivideBundleSplitAlgorithm();
    public static final NamespaceBundleSplitAlgorithm TOPIC_COUNT_EQUALLY_DIVIDE_ALGO = new TopicCountEquallyDivideBundleSplitAlgorithm();

    public static NamespaceBundleSplitAlgorithm of(String algorithmName) {
        if (algorithmName == null) {
            return null;
        }
        switch (algorithmName) {
            case "range_equally_divide": {
                return RANGE_EQUALLY_DIVIDE_ALGO;
            }
            case "topic_count_equally_divide": {
                return TOPIC_COUNT_EQUALLY_DIVIDE_ALGO;
            }
        }
        return null;
    }

    public CompletableFuture<Long> getSplitBoundary(NamespaceService var1, NamespaceBundle var2);
}

