/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFPercentileApprox;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.hive.execution.TestingTypedCount;
import org.apache.spark.sql.hive.execution.TestingTypedCount$;
import org.apache.spark.sql.hive.test.TestHive$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class ObjectHashAggregateExecBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static ObjectHashAggregateExecBenchmark$ MODULE$;
    private final Function1<String, Dataset<Row>> sql;
    private final SparkSession spark;
    private String sparkHome;
    private volatile boolean bitmap$0;

    static {
        new ObjectHashAggregateExecBenchmark$();
    }

    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$((SqlBasedBenchmark)this, (String)name, (long)cardinality, f);
    }

    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$((SqlBasedBenchmark)this, ds);
    }

    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$((SqlBasedBenchmark)this, (Benchmark)benchmark);
    }

    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$((SqlBasedBenchmark)this, (String)path, (int)rowsNum, (int)numCols);
    }

    public void afterAll() {
        SqlBasedBenchmark.afterAll$((SqlBasedBenchmark)this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private String sparkHome$lzycompute() {
        ObjectHashAggregateExecBenchmark$ objectHashAggregateExecBenchmark$ = this;
        synchronized (objectHashAggregateExecBenchmark$) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public SparkSession getSparkSession() {
        return TestHive$.MODULE$.sparkSession();
    }

    private Function1<String, Dataset<Row>> sql() {
        return this.sql;
    }

    private void hiveUDAFvsSparkAF(int N) {
        Benchmark benchmark = new Benchmark("hive udaf vs spark af", (long)N, 5, new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds(), new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds(), true, this.output());
        this.sql().apply((Object)new StringBuilder(54).append("CREATE TEMPORARY FUNCTION hive_percentile_approx AS '").append(GenericUDAFPercentileApprox.class.getName()).append("'").toString());
        this.spark().range((long)N).createOrReplaceTempView("t");
        benchmark.addCase("hive udaf w/o group by", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.USE_OBJECT_HASH_AGG().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark((Dataset)MODULE$.sql().apply((Object)"SELECT hive_percentile_approx(id, 0.5) FROM t")).noop()));
        benchmark.addCase("spark af w/o group by", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.USE_OBJECT_HASH_AGG().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark((Dataset)MODULE$.sql().apply((Object)"SELECT percentile_approx(id, 0.5) FROM t")).noop()));
        benchmark.addCase("hive udaf w/ group by", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.USE_OBJECT_HASH_AGG().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark((Dataset)MODULE$.sql().apply((Object)new StringBuilder(76).append("SELECT hive_percentile_approx(id, 0.5) FROM t GROUP BY CAST(id / ").append(N / 4).append(" AS BIGINT)").toString())).noop()));
        benchmark.addCase("spark af w/ group by w/o fallback", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.USE_OBJECT_HASH_AGG().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark((Dataset)MODULE$.sql().apply((Object)new StringBuilder(71).append("SELECT percentile_approx(id, 0.5) FROM t GROUP BY CAST(id / ").append(N / 4).append(" AS BIGINT)").toString())).noop()));
        benchmark.addCase("spark af w/ group by w/ fallback", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$5 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.USE_OBJECT_HASH_AGG().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.OBJECT_AGG_SORT_BASED_FALLBACK_THRESHOLD().key()), (Object)"2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark((Dataset)MODULE$.sql().apply((Object)new StringBuilder(71).append("SELECT percentile_approx(id, 0.5) FROM t GROUP BY CAST(id / ").append(N / 4).append(" AS BIGINT)").toString())).noop()));
        benchmark.run();
    }

    private void objectHashAggregateExecVsSortAggregateExecUsingTypedCount(int N) {
        Benchmark benchmark = new Benchmark("object agg v.s. sort agg", (long)N, 1, new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds(), new package.DurationInt(package$.MODULE$.DurationInt(45)).seconds(), true, this.output());
        Dataset df = this.spark().range((long)N);
        benchmark.addCase("sort agg w/ group by", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$6 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.USE_OBJECT_HASH_AGG().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark(df.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$less((Object)BoxesRunTime.boxToInteger((int)(N / 2)))})).agg(ObjectHashAggregateExecBenchmark$.typed_count$1((Column)MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]))).noop()));
        benchmark.addCase("object agg w/ group by w/o fallback", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$7 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.USE_OBJECT_HASH_AGG().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark(df.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$less((Object)BoxesRunTime.boxToInteger((int)(N / 2)))})).agg(ObjectHashAggregateExecBenchmark$.typed_count$1((Column)MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]))).noop()));
        benchmark.addCase("object agg w/ group by w/ fallback", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$8 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.USE_OBJECT_HASH_AGG().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.OBJECT_AGG_SORT_BASED_FALLBACK_THRESHOLD().key()), (Object)"2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark(df.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$less((Object)BoxesRunTime.boxToInteger((int)(N / 2)))})).agg(ObjectHashAggregateExecBenchmark$.typed_count$1((Column)MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]))).noop()));
        benchmark.addCase("sort agg w/o group by", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$9 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.USE_OBJECT_HASH_AGG().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark(df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{ObjectHashAggregateExecBenchmark$.typed_count$1((Column)MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$))}))).noop()));
        benchmark.addCase("object agg w/o group by w/o fallback", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$10 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.USE_OBJECT_HASH_AGG().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark(df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{ObjectHashAggregateExecBenchmark$.typed_count$1((Column)MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$))}))).noop()));
        benchmark.run();
    }

    private void objectHashAggregateExecVsSortAggregateExecUsingPercentileApprox(int N) {
        Benchmark benchmark = new Benchmark("object agg v.s. sort agg", (long)N, 5, new package.DurationInt(package$.MODULE$.DurationInt(15)).seconds(), new package.DurationInt(package$.MODULE$.DurationInt(45)).seconds(), true, this.output());
        Dataset df = this.spark().range((long)N).coalesce(1);
        benchmark.addCase("sort agg w/ group by", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$11 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.USE_OBJECT_HASH_AGG().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark(df.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$div((Object)BoxesRunTime.boxToInteger((int)(N / 4))).cast((DataType)LongType$.MODULE$)})).agg(MODULE$.percentile_approx((Column)MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$), 0.5, MODULE$.percentile_approx$default$3()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]))).noop()));
        benchmark.addCase("object agg w/ group by w/o fallback", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$12 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.USE_OBJECT_HASH_AGG().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark(df.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$div((Object)BoxesRunTime.boxToInteger((int)(N / 4))).cast((DataType)LongType$.MODULE$)})).agg(MODULE$.percentile_approx((Column)MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$), 0.5, MODULE$.percentile_approx$default$3()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]))).noop()));
        benchmark.addCase("object agg w/ group by w/ fallback", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$13 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.USE_OBJECT_HASH_AGG().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.OBJECT_AGG_SORT_BASED_FALLBACK_THRESHOLD().key()), (Object)"2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark(df.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$div((Object)BoxesRunTime.boxToInteger((int)(N / 4))).cast((DataType)LongType$.MODULE$)})).agg(MODULE$.percentile_approx((Column)MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$), 0.5, MODULE$.percentile_approx$default$3()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]))).noop()));
        benchmark.addCase("sort agg w/o group by", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$14 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.USE_OBJECT_HASH_AGG().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark(df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.percentile_approx((Column)MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$), 0.5, MODULE$.percentile_approx$default$3())}))).noop()));
        benchmark.addCase("object agg w/o group by w/o fallback", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$15 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.USE_OBJECT_HASH_AGG().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark(df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.percentile_approx((Column)MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$), 0.5, MODULE$.percentile_approx$default$3())}))).noop()));
        benchmark.run();
    }

    private Column percentile_approx(Column column, double percentage, boolean isDistinct) {
        ApproximatePercentile approxPercentile = new ApproximatePercentile(column.expr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)percentage)));
        return Column$.MODULE$.apply((Expression)approxPercentile.toAggregateExpression(isDistinct, approxPercentile.toAggregateExpression$default$2()));
    }

    private boolean percentile_approx$default$3() {
        return false;
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("Hive UDAF vs Spark AF", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.hiveUDAFvsSparkAF(65536));
        this.runBenchmark("ObjectHashAggregateExec vs SortAggregateExec - typed_count", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.objectHashAggregateExecVsSortAggregateExecUsingTypedCount(0x6400000));
        this.runBenchmark("ObjectHashAggregateExec vs SortAggregateExec - percentile_approx", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.objectHashAggregateExecVsSortAggregateExecUsingPercentileApprox(0x200000));
    }

    private static final Column typed_count$1(Column column) {
        return Column$.MODULE$.apply((Expression)new TestingTypedCount(column.expr(), TestingTypedCount$.MODULE$.apply$default$2(), TestingTypedCount$.MODULE$.apply$default$3()).toAggregateExpression());
    }

    private ObjectHashAggregateExecBenchmark$() {
        MODULE$ = this;
        SQLHelper.$init$((SQLHelper)this);
        SqlBasedBenchmark.$init$((SqlBasedBenchmark)this);
        this.sql = (Function1 & Serializable & scala.Serializable)sqlText -> MODULE$.spark().sql(sqlText);
    }
}

