/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import com.google.common.io.Files;
import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.orc.OrcConf;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.orc.OrcQueryTest;
import org.apache.spark.sql.execution.datasources.orc.OrcTest;
import org.apache.spark.sql.hive.HiveSessionCatalog;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.orc.HiveOrcQuerySuite$;
import org.apache.spark.sql.hive.orc.OrcFileFormat;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001I3AAB\u0004\u0001)!)A\u0005\u0001C\u0001K!9\u0001\u0006\u0001b\u0001\n\u0003J\u0003BB\u001c\u0001A\u0003%!\u0006C\u00039\u0001\u0011%\u0011\bC\u0003K\u0001\u0011%1JA\tISZ,wJ]2Rk\u0016\u0014\u0018pU;ji\u0016T!\u0001C\u0005\u0002\u0007=\u00148M\u0003\u0002\u000b\u0017\u0005!\u0001.\u001b<f\u0015\taQ\"A\u0002tc2T!AD\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005A\t\u0012AB1qC\u000eDWMC\u0001\u0013\u0003\ry'oZ\u0002\u0001'\r\u0001QC\b\t\u0003-qi\u0011a\u0006\u0006\u0003\u0011aQ!!\u0007\u000e\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u00037-\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005u9\"\u0001D(sGF+XM]=UKN$\bCA\u0010#\u001b\u0005\u0001#BA\u0011\n\u0003\u0011!Xm\u001d;\n\u0005\r\u0002#!\u0005+fgRD\u0015N^3TS:<G.\u001a;p]\u00061A(\u001b8jiz\"\u0012A\n\t\u0003O\u0001i\u0011aB\u0001\u0007_J\u001c\u0017*\u001c9\u0016\u0003)\u0002\"a\u000b\u001b\u000f\u00051\u0012\u0004CA\u00171\u001b\u0005q#BA\u0018\u0014\u0003\u0019a$o\\8u})\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\u00051\u0001K]3eK\u001aL!!\u000e\u001c\u0003\rM#(/\u001b8h\u0015\t\u0019\u0004'A\u0004pe\u000eLU\u000e\u001d\u0011\u00021\u001d,GoQ1dQ\u0016$G)\u0019;b'>,(oY3UC\ndW\r\u0006\u0002;\tB\u00111HQ\u0007\u0002y)\u0011QHP\u0001\bY><\u0017nY1m\u0015\ty\u0004)A\u0003qY\u0006t7O\u0003\u0002B\u0017\u0005A1-\u0019;bYf\u001cH/\u0003\u0002Dy\tYAj\\4jG\u0006d\u0007\u000b\\1o\u0011\u0015)E\u00011\u0001G\u0003\u0015!\u0018M\u00197f!\t9\u0005*D\u0001A\u0013\tI\u0005IA\bUC\ndW-\u00133f]RLg-[3s\u0003-\u0019\u0007.Z2l\u0007\u0006\u001c\u0007.\u001a3\u0015\u00051\u0003\u0006CA'O\u001b\u0005\u0001\u0014BA(1\u0005\u0011)f.\u001b;\t\u000bE+\u0001\u0019\u0001$\u0002\u001fQ\f'\r\\3JI\u0016tG/\u001b4jKJ\u0004")
public class HiveOrcQuerySuite
extends OrcQueryTest
implements TestHiveSingleton {
    private final String orcImp;
    private final boolean enableAutoThreadAudit;
    private final SparkSession spark;
    private final TestHiveContext hiveContext;
    private final HiveClient hiveClient;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        OrcTest.afterAll$((OrcTest)this);
    }

    @Override
    public void afterAll() {
        TestHiveSingleton.afterAll$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    public String orcImp() {
        return this.orcImp;
    }

    private LogicalPlan getCachedDataSourceTable(TableIdentifier table) {
        return ((HiveSessionCatalog)this.spark().sessionState().catalog()).metastoreCatalog().getCachedDataSourceTable(table);
    }

    private void checkCached(TableIdentifier tableIdentifier) {
        LogicalRelation logicalRelation;
        LogicalPlan logicalPlan = this.getCachedDataSourceTable(tableIdentifier);
        if (logicalPlan == null) {
            throw this.fail(new StringBuilder(41).append("Converted ").append(tableIdentifier.table()).append(" should be cached in the cache.").toString(), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        }
        if (logicalPlan instanceof LogicalRelation && (logicalRelation = (LogicalRelation)logicalPlan).relation() instanceof HadoopFsRelation) {
            return;
        }
        throw this.fail(new StringBuilder(79).append("The cached ").append(tableIdentifier.table()).append(" should be a HadoopFsRelation. ").append("However, ").append(logicalPlan).append(" is returned form the cache.").toString(), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
    }

    public static final /* synthetic */ void $anonfun$new$2(HiveOrcQuerySuite $this, File dir) {
        String path = dir.getCanonicalPath();
        $this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"empty_orc"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempView((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"empty", "single"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(117).append("CREATE TABLE empty_orc(key INT, value STRING)\n               |STORED AS ORC\n               |LOCATION '").append(dir.toURI()).append("'\n             ").toString())).stripMargin());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveOrcQuerySuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator6$1(HiveOrcQuerySuite $outer) {
                }
            }
            Dataset emptyDF = $this.testImplicits().localSeqToDatasetHolder((Seq)Nil$.MODULE$, $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"})).coalesce(1);
            emptyDF.createOrReplaceTempView("empty");
            Path zeroPath = new Path(path, "zero.orc");
            zeroPath.getFileSystem($this.spark().sessionState().newHadoopConf()).create(zeroPath);
            AnalysisException x$1 = (AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().read().orc(path), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            String x$2 = "UNABLE_TO_INFER_SCHEMA";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format"), (Object)"ORC")}));
            Option x$4 = $this.checkError$default$3();
            boolean x$5 = $this.checkError$default$5();
            QueryContext[] x$6 = $this.checkError$default$6();
            $this.checkError((SparkThrowable)x$1, x$2, x$4, x$3, x$5, x$6);
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(HiveOrcQuerySuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator16$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator16$1(HiveOrcQuerySuite $outer) {
                }
            }
            Dataset singleRowDF = $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)"foo"), (List)Nil$.MODULE$), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator16$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"})).coalesce(1);
            singleRowDF.createOrReplaceTempView("single");
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("INSERT INTO TABLE empty_orc\n               |SELECT key, value FROM single\n             ")).stripMargin());
            Dataset df = $this.spark().read().orc(path);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(df.schema());
            StructType $org_scalatest_assert_macro_right = singleRowDF.schema().asNullable();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df, singleRowDF);
        }));
    }

    public static final /* synthetic */ void $anonfun$new$12(HiveOrcQuerySuite $this, Dataset singleRowDF$1, String orcConversion$1, File dir) {
        String path = dir.getCanonicalPath();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(150).append("\n                   |CREATE TABLE dummy_orc(key INT, value STRING)\n                   |STORED AS ORC\n                   |LOCATION '").append(dir.toURI()).append("'\n                 ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                   |INSERT INTO TABLE dummy_orc\n                   |SELECT key, value FROM single\n                 ")).stripMargin());
        Dataset df = $this.spark().sql("SELECT * FROM dummy_orc WHERE key=0");
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df, singleRowDF$1);
        QueryExecution queryExecution = df.queryExecution();
        String string = orcConversion$1;
        String string2 = "true";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            queryExecution.analyzed().collectFirst((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof LogicalRelation) {
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan = x1;
                    return logicalPlan instanceof LogicalRelation;
                }
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.fail(new StringBuilder(66).append("Expecting the query plan to convert orc to data sources, ").append("but got:\n").append(queryExecution).toString(), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112)));
            return;
        }
        queryExecution.analyzed().collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof HiveTableRelation) {
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(LogicalPlan x2) {
                LogicalPlan logicalPlan = x2;
                return logicalPlan instanceof HiveTableRelation;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.fail(new StringBuilder(59).append("Expecting no conversion from orc to data sources, ").append("but got:\n").append(queryExecution).toString(), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119)));
    }

    public static final /* synthetic */ void $anonfun$new$19(HiveOrcQuerySuite $this, File dir) {
        Dataset df = $this.spark().range(5L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "id as valueField", "id as partitionValue"}));
        df.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitionValue"})).mode("overwrite").orc(dir.getAbsolutePath());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(173).append("\n            |create external table dummy_orc (id long, valueField long)\n            |partitioned by (partitionValue int)\n            |stored as orc\n            |location \"").append(dir.toURI()).append("\"").toString())).stripMargin());
        $this.spark().sql("msck repair table dummy_orc");
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("select * from dummy_orc"), df);
    }

    public static final /* synthetic */ void $anonfun$new$22(HiveOrcQuerySuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String orcImpl = (String)tuple2._1();
            Class format = (Class)tuple2._2();
            $this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_IMPLEMENTATION().key()), (Object)orcImpl)}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark_20728"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Option fileFormat;
                $this.sql().apply((Object)"CREATE TABLE spark_20728(a INT) USING ORC");
                Option $org_scalatest_assert_macro_left = fileFormat = ((Dataset)$this.sql().apply((Object)"SELECT * FROM spark_20728")).queryExecution().analyzed().collectFirst((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                        A1 A1 = x3;
                        if (A1 instanceof LogicalRelation) {
                            LogicalRelation logicalRelation = (LogicalRelation)A1;
                            return (B1)((HadoopFsRelation)logicalRelation.relation()).fileFormat().getClass();
                        }
                        return (B1)function1.apply(x3);
                    }

                    public final boolean isDefinedAt(LogicalPlan x3) {
                        LogicalPlan logicalPlan = x3;
                        return logicalPlan instanceof LogicalRelation;
                    }
                });
                Some $org_scalatest_assert_macro_right = new Some((Object)format);
                Option option = $org_scalatest_assert_macro_left;
                Some some = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            }));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$28(HiveOrcQuerySuite $this, File f) {
        String path = f.getCanonicalPath();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveOrcQuerySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator36$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator36$1(HiveOrcQuerySuite $outer) {
            }
        }
        $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator36$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2"})).write().orc(path);
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().read().orc(path), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)convertMetastoreOrc -> {
            $this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)convertMetastoreOrc)))}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(65).append("CREATE EXTERNAL TABLE t(c2 INT, c1 INT) STORED AS ORC LOCATION '").append(path$2).append("'").toString());
                $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})));
            }));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$57(HiveOrcQuerySuite $this, String orcImpl) {
        ((IterableLike)new .colon.colon((Object)"false", (List)new .colon.colon((Object)"true", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)vectorized -> {
            $this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_IMPLEMENTATION().key()), (Object)orcImpl), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)vectorized)}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test_hive_orc_impl"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 | CREATE TABLE test_hive_orc_impl\n                 | (_col1 INT, _col2 STRING, _col3 INT)\n                 | STORED AS ORC\n               ")).stripMargin());
                $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 | INSERT INTO\n                 | test_hive_orc_impl\n                 | VALUES(9, '12', 2020)\n               ")).stripMargin());
                Dataset df = $this.spark().sql("SELECT _col2 FROM test_hive_orc_impl");
                $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df, Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"12"})));
            }));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$67(HiveOrcQuerySuite $this, boolean forcePositionalEvolution$1, File f) {
        String path = f.getCanonicalPath();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveOrcQuerySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator56$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.Integer").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.Integer").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator56$1(HiveOrcQuerySuite $outer) {
            }
        }
        $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)Predef$.MODULE$.int2Integer(1), (Object)Predef$.MODULE$.int2Integer(2)), (List)new .colon.colon((Object)new Tuple2((Object)Predef$.MODULE$.int2Integer(3), (Object)Predef$.MODULE$.int2Integer(4)), (List)new .colon.colon((Object)new Tuple2((Object)Predef$.MODULE$.int2Integer(5), (Object)Predef$.MODULE$.int2Integer(6)), (List)new .colon.colon((Object)new Tuple2(null, null), (List)Nil$.MODULE$)))), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator56$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2"})).write().orc(path);
        Seq correctAnswer = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)6)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), (List)Nil$.MODULE$))));
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().read().orc(path), correctAnswer);
        $this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(65).append("CREATE EXTERNAL TABLE t(c3 INT, c2 INT) STORED AS ORC LOCATION '").append(path).append("'").toString());
            Seq expected = forcePositionalEvolution$1 ? correctAnswer : (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)6)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null})), (List)Nil$.MODULE$))));
            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), expected);
        });
    }

    public static final /* synthetic */ void $anonfun$new$64(HiveOrcQuerySuite $this, String orcImpl$2, boolean forcePositionalEvolution) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)convertMetastore -> {
            $this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_IMPLEMENTATION().key()), (Object)orcImpl$2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcConf.FORCE_POSITIONAL_EVOLUTION.getAttribute()), (Object)Boolean.toString(forcePositionalEvolution)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)convertMetastore)))}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempPath((Function1 & Serializable & scala.Serializable)f -> {
                HiveOrcQuerySuite.$anonfun$new$67($this, forcePositionalEvolution$1, f);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$63(HiveOrcQuerySuite $this, String orcImpl) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)forcePositionalEvolution -> {
            HiveOrcQuerySuite.$anonfun$new$64($this, orcImpl, BoxesRunTime.unboxToBoolean((Object)forcePositionalEvolution));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$76(HiveOrcQuerySuite $this, boolean forcePositionalEvolution$2, File f) {
        String path = f.getCanonicalPath();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveOrcQuerySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator66$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("java.lang.Integer").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.Integer").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.Integer").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
            }

            public Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator66$1(HiveOrcQuerySuite $outer) {
            }
        }
        $this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)Predef$.MODULE$.int2Integer(1), (Object)Predef$.MODULE$.int2Integer(2), (Object)Predef$.MODULE$.int2Integer(1)), (List)new .colon.colon((Object)new Tuple3((Object)Predef$.MODULE$.int2Integer(3), (Object)Predef$.MODULE$.int2Integer(4), (Object)Predef$.MODULE$.int2Integer(2)), (List)new .colon.colon((Object)new Tuple3((Object)Predef$.MODULE$.int2Integer(5), (Object)Predef$.MODULE$.int2Integer(6), (Object)Predef$.MODULE$.int2Integer(3)), (List)new .colon.colon((Object)new Tuple3(null, null, (Object)Predef$.MODULE$.int2Integer(4)), (List)Nil$.MODULE$)))), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator66$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2", "p"})).write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p"})).orc(path);
        Seq correctAnswer = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$))));
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().read().orc(path), correctAnswer);
        $this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(200).append("\n                     |CREATE EXTERNAL TABLE t(c3 INT, c2 INT)\n                     |PARTITIONED BY (p int)\n                     |STORED AS ORC\n                     |LOCATION '").append(path).append("'\n                     |").toString())).stripMargin());
            $this.sql().apply((Object)"MSCK REPAIR TABLE t");
            Seq expected = forcePositionalEvolution$2 ? correctAnswer : (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$))));
            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), expected);
        });
    }

    public static final /* synthetic */ void $anonfun$new$73(HiveOrcQuerySuite $this, String orcImpl$3, boolean forcePositionalEvolution) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)convertMetastore -> {
            $this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_IMPLEMENTATION().key()), (Object)orcImpl$3), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcConf.FORCE_POSITIONAL_EVOLUTION.getAttribute()), (Object)Boolean.toString(forcePositionalEvolution)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)convertMetastore)))}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempPath((Function1 & Serializable & scala.Serializable)f -> {
                HiveOrcQuerySuite.$anonfun$new$76($this, forcePositionalEvolution$2, f);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$72(HiveOrcQuerySuite $this, String orcImpl) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)forcePositionalEvolution -> {
            HiveOrcQuerySuite.$anonfun$new$73($this, orcImpl, BoxesRunTime.unboxToBoolean((Object)forcePositionalEvolution));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$81(HiveOrcQuerySuite $this, File dir) {
        String basePath = dir.getCanonicalPath();
        $this.spark().range(0L, 1L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).write().orc(new Path(basePath, "foo=1").toString());
        $this.spark().range(0L, 1L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})).write().json(new Path(basePath, "foo=2").toString());
        $this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.IGNORE_CORRUPT_FILES().key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_IMPLEMENTATION().key()), (Object)"hive")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)mergeSchema -> {
            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().read().option("mergeSchema", mergeSchema).option("ignoreCorruptFiles", true).orc(basePath$1), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0L), BoxesRunTime.boxToInteger((int)1)})));
            return BoxedUnit.UNIT;
        }));
    }

    public HiveOrcQuerySuite() {
        TestHiveSingleton.$init$(this);
        this.orcImp = "hive";
        this.test("SPARK-8501: Avoids discovery schema from empty ORC files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1 & Serializable & scala.Serializable)dir -> {
            HiveOrcQuerySuite.$anonfun$new$2(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        this.test("Verify the ORC conversion parameter: CONVERT_METASTORE_ORC", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"single"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveOrcQuerySuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator26$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator26$1(HiveOrcQuerySuite $outer) {
                }
            }
            Dataset singleRowDF = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)"foo"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator26$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"}));
            singleRowDF.createOrReplaceTempView("single");
            ((IterableLike)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)orcConversion -> {
                this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)orcConversion)}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dummy_orc"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1 & Serializable & scala.Serializable)dir -> {
                    HiveOrcQuerySuite.$anonfun$new$12($this, singleRowDF$1, orcConversion, dir);
                    return BoxedUnit.UNIT;
                })));
                return BoxedUnit.UNIT;
            });
        }), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("converted ORC table supports resolving mixed case field", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dummy_orc"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1 & Serializable & scala.Serializable)dir -> {
            HiveOrcQuerySuite.$anonfun$new$19(this, dir);
            return BoxedUnit.UNIT;
        }))), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("SPARK-20728 Make ORCFileFormat configurable between sql/hive and sql/core", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)new Tuple2((Object)"native", org.apache.spark.sql.execution.datasources.orc.OrcFileFormat.class), (List)new .colon.colon((Object)new Tuple2((Object)"hive", OrcFileFormat.class), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HiveOrcQuerySuite.$anonfun$new$22(this, x0$1);
            return BoxedUnit.UNIT;
        }), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("SPARK-22267 Spark SQL incorrectly reads ORC files when column order is different", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"native", (List)new .colon.colon((Object)"hive", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)orcImpl -> {
            this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_IMPLEMENTATION().key()), (Object)orcImpl)}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1 & Serializable & scala.Serializable)f -> {
                HiveOrcQuerySuite.$anonfun$new$28($this, f);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        this.test("SPARK-19809 NullPointerException on zero-size ORC file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"native", (List)new .colon.colon((Object)"hive", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)orcImpl -> {
            this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_IMPLEMENTATION().key()), (Object)orcImpl)}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1 & Serializable & scala.Serializable)dir -> {
                $this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark_19809"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.sql().apply((Object)new StringBuilder(57).append("CREATE TABLE spark_19809(a int) STORED AS ORC LOCATION '").append(dir).append("'").toString());
                    Files.touch((File)new File(String.valueOf(dir.getCanonicalPath()), "zero.orc"));
                    ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)convertMetastoreOrc -> {
                        $this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)convertMetastoreOrc)))}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table("spark_19809"), (Seq)Nil$.MODULE$));
                        return BoxedUnit.UNIT;
                    });
                });
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        this.ignore("SPARK-23340 Empty float/double array columns raise EOFException", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark_23340"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE spark_23340(a array<float>, b array<double>) STORED AS ORC");
            this.sql().apply((Object)"INSERT INTO spark_23340 VALUES (array(), array())");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().table("spark_23340"), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Array$.MODULE$.empty(ClassTag$.MODULE$.Float()), Array$.MODULE$.empty(ClassTag$.MODULE$.Double())})), (List)Nil$.MODULE$));
        })), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
        this.test("SPARK-26437 Can not query decimal type when value is 0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark_26437"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE spark_26437 STORED AS ORCFILE AS SELECT 0.00 AS c1");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().table("spark_26437"), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)0.0)})), (List)Nil$.MODULE$));
        })), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
        this.test("SPARK-28573 ORC conversation could be applied for partitioned table insertion", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"single"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveOrcQuerySuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator46$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator46$1(HiveOrcQuerySuite $outer) {
                }
            }
            Dataset singleRowDF = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)"foo"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator46$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"}));
            singleRowDF.createOrReplaceTempView("single");
            ((IterableLike)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)conversion -> {
                this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_INSERTING_PARTITIONED_TABLE().key()), (Object)conversion)}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dummy_orc_partitioned"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    Assertion assertion;
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE dummy_orc_partitioned(key INT, value STRING)\n                 |PARTITIONED by (`date` STRING)\n                 |STORED AS ORC\n                 ")).stripMargin());
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |INSERT INTO TABLE dummy_orc_partitioned\n                 |PARTITION (`date` = '2019-04-01')\n                 |SELECT key, value FROM single\n                 ")).stripMargin());
                    TableIdentifier orcPartitionedTable = TableIdentifier$.MODULE$.apply("dummy_orc_partitioned", (Option)new Some((Object)"default"));
                    String string = conversion;
                    String string2 = "true";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.getCachedDataSourceTable(orcPartitionedTable));
                        Null$ $org_scalatest_assert_macro_right = null;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
                    } else {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.getCachedDataSourceTable(orcPartitionedTable));
                        Null$ $org_scalatest_assert_macro_right = null;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
                    }
                    Dataset df = $this.spark().sql("SELECT key, value FROM dummy_orc_partitioned WHERE key=0");
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df, singleRowDF$2);
                }));
                return BoxedUnit.UNIT;
            });
        }), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
        this.test("SPARK-32234 read ORC table with column names all starting with '_col'", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"native", (List)new .colon.colon((Object)"hive", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)orcImpl -> {
            HiveOrcQuerySuite.$anonfun$new$57(this, orcImpl);
            return BoxedUnit.UNIT;
        }), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
        this.test("SPARK-32864: Support ORC forced positional evolution", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"native", (List)new .colon.colon((Object)"hive", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)orcImpl -> {
            HiveOrcQuerySuite.$anonfun$new$63(this, orcImpl);
            return BoxedUnit.UNIT;
        }), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
        this.test("SPARK-32864: Support ORC forced positional evolution with partitioned table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"native", (List)new .colon.colon((Object)"hive", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)orcImpl -> {
            HiveOrcQuerySuite.$anonfun$new$72(this, orcImpl);
            return BoxedUnit.UNIT;
        }), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
        this.test("SPARK-49094: ignoreCorruptFiles works for hive orc w/ mergeSchema off", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1 & Serializable & scala.Serializable)dir -> {
            HiveOrcQuerySuite.$anonfun$new$81(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
    }
}

