/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import scala.Array$;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0001\u0003\t5\u0011a\u0003T3bgR\u001c\u0016/^1sKN\fum\u001a:fO\u0006$xN\u001d\u0006\u0003\u0007\u0011\t!B]3he\u0016\u001c8/[8o\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fUI!A\u0006\t\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011a\u0001!\u0011!Q\u0001\ne\taBY2D_\u00164g-[2jK:$8\u000fE\u0002\u001b;}i\u0011a\u0007\u0006\u00039\u0019\t\u0011B\u0019:pC\u0012\u001c\u0017m\u001d;\n\u0005yY\"!\u0003\"s_\u0006$7-Y:u!\t\u00013%D\u0001\"\u0015\t\u0011C!\u0001\u0004mS:\fGnZ\u0005\u0003I\u0005\u0012aAV3di>\u0014\b\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u00111\f'-\u001a7Ti\u0012\u0004\"a\u0004\u0015\n\u0005%\u0002\"A\u0002#pk\ndW\r\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003(\u0003%a\u0017MY3m\u001b\u0016\fg\u000e\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u000311\u0017\u000e^%oi\u0016\u00148-\u001a9u!\tyq&\u0003\u00021!\t9!i\\8mK\u0006t\u0007\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\u0002\u001b\t\u001cg)Z1ukJ,7o\u0015;e!\rQR\u0004\u000e\t\u0004\u001fU:\u0013B\u0001\u001c\u0011\u0005\u0015\t%O]1z\u0011!A\u0004A!A!\u0002\u0013\u0019\u0014A\u00042d\r\u0016\fG/\u001e:fg6+\u0017M\u001c\u0005\u0006u\u0001!\taO\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fqrt\bQ!C\u0007B\u0011Q\bA\u0007\u0002\u0005!)\u0001$\u000fa\u00013!)a%\u000fa\u0001O!)1&\u000fa\u0001O!)Q&\u000fa\u0001]!)!'\u000fa\u0001g!)\u0001(\u000fa\u0001g!9Q\t\u0001a\u0001\n\u00131\u0015\u0001\u0003;pi\u0006d7I\u001c;\u0016\u0003\u001d\u0003\"a\u0004%\n\u0005%\u0003\"\u0001\u0002'p]\u001eDqa\u0013\u0001A\u0002\u0013%A*\u0001\u0007u_R\fGn\u00118u?\u0012*\u0017\u000f\u0006\u0002N!B\u0011qBT\u0005\u0003\u001fB\u0011A!\u00168ji\"9\u0011KSA\u0001\u0002\u00049\u0015a\u0001=%c!11\u000b\u0001Q!\n\u001d\u000b\u0011\u0002^8uC2\u001ce\u000e\u001e\u0011\t\u000fU\u0003\u0001\u0019!C\u0005-\u0006Iq/Z5hQR\u001cV/\\\u000b\u0002O!9\u0001\f\u0001a\u0001\n\u0013I\u0016!D<fS\u001eDGoU;n?\u0012*\u0017\u000f\u0006\u0002N5\"9\u0011kVA\u0001\u0002\u00049\u0003B\u0002/\u0001A\u0003&q%\u0001\u0006xK&<\u0007\u000e^*v[\u0002BqA\u0018\u0001A\u0002\u0013%a+A\u0004m_N\u001c8+^7\t\u000f\u0001\u0004\u0001\u0019!C\u0005C\u0006YAn\\:t'Vlw\fJ3r)\ti%\rC\u0004R?\u0006\u0005\t\u0019A\u0014\t\r\u0011\u0004\u0001\u0015)\u0003(\u0003!awn]:Tk6\u0004\u0003b\u00024\u0001\u0005\u0004%IaZ\u0001\u0004I&lW#\u00015\u0011\u0005=I\u0017B\u00016\u0011\u0005\rIe\u000e\u001e\u0005\u0007Y\u0002\u0001\u000b\u0011\u00025\u0002\t\u0011LW\u000e\t\u0005\t]\u0002A)\u0019!C\u0005_\u0006Ya-Z1ukJ,7o\u0015;e+\u0005!\u0004\u0002C9\u0001\u0011\u0003\u0005\u000b\u0015\u0002\u001b\u0002\u0019\u0019,\u0017\r^;sKN\u001cF\u000f\u001a\u0011)\u0005A\u001c\bCA\bu\u0013\t)\bCA\u0005ue\u0006t7/[3oi\"Aq\u000f\u0001EC\u0002\u0013%\u00010\u0001\ffM\u001a,7\r^5wK\u000e{WMZ!oI>3gm]3u+\u0005I\b\u0003B\b{?\u001dJ!a\u001f\t\u0003\rQ+\b\u000f\\33\u0011!i\b\u0001#A!B\u0013I\u0018aF3gM\u0016\u001cG/\u001b<f\u0007>,g-\u00118e\u001f\u001a47/\u001a;!Q\ta8\u000f\u0003\u0006\u0002\u0002\u0001A)\u0019!C\u0005\u0003\u0007\t1$\u001a4gK\u000e$\u0018N^3D_\u00164g-[2jK:$8OV3di>\u0014X#A\u0010\t\u0013\u0005\u001d\u0001\u0001#A!B\u0013y\u0012\u0001H3gM\u0016\u001cG/\u001b<f\u0007>,gMZ5dS\u0016tGo\u001d,fGR|'\u000f\t\u0015\u0004\u0003\u000b\u0019\b\"CA\u0007\u0001!\u0015\r\u0011\"\u0003W\u0003\u0019ygMZ:fi\"I\u0011\u0011\u0003\u0001\t\u0002\u0003\u0006KaJ\u0001\b_\u001a47/\u001a;!Q\r\tya\u001d\u0005\n\u0003/\u0001\u0001R1A\u0005\n=\f\u0001c\u001a:bI&,g\u000e^*v[\u0006\u0013(/Y=\t\u0013\u0005m\u0001\u0001#A!B\u0013!\u0014!E4sC\u0012LWM\u001c;Tk6\f%O]1zA!9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0012aA1eIR!\u00111EA\u0013\u001b\u0005\u0001\u0001\u0002CA\u0014\u0003;\u0001\r!!\u000b\u0002\u0011%t7\u000f^1oG\u0016\u0004B!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0004\u0003_!\u0011a\u00024fCR,(/Z\u0005\u0005\u0003g\tiC\u0001\u0005J]N$\u0018M\\2f\u0011\u001d\t9\u0004\u0001C\u0001\u0003s\tQ!\\3sO\u0016$B!a\t\u0002<!9\u0011QHA\u001b\u0001\u0004a\u0014!B8uQ\u0016\u0014\bBBA!\u0001\u0011\u0005a)A\u0003d_VtG\u000f\u0003\u0004\u0002F\u0001!\tAV\u0001\u0005Y>\u001c8\u000fC\u0004\u0002J\u0001!\t!a\u0001\u0002\u0011\u001d\u0014\u0018\rZ5f]R\u0004")
public class LeastSquaresAggregator
implements Serializable {
    private final Broadcast<Vector> bcCoefficients;
    private final double labelStd;
    private final double labelMean;
    private final boolean fitIntercept;
    private final Broadcast<double[]> bcFeaturesStd;
    private final Broadcast<double[]> bcFeaturesMean;
    private long totalCnt;
    private double org$apache$spark$ml$regression$LeastSquaresAggregator$$weightSum;
    private double lossSum;
    private final int dim;
    private transient double[] featuresStd;
    private transient Tuple2<Vector, Object> effectiveCoefAndOffset;
    private transient Vector effectiveCoefficientsVector;
    private transient double offset;
    private double[] gradientSumArray;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    private double[] featuresStd$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.featuresStd = (double[])this.bcFeaturesStd.value();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.featuresStd;
        }
    }

    private Tuple2 effectiveCoefAndOffset$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                double[] coefficientsArray = (double[])((Vector)this.bcCoefficients.value()).toArray().clone();
                double[] featuresMean = (double[])this.bcFeaturesMean.value();
                double sum = 0.0;
                int len = coefficientsArray.length;
                for (int i = 0; i < len; ++i) {
                    if (this.featuresStd()[i] != 0.0) {
                        int n = i;
                        coefficientsArray[n] = coefficientsArray[n] / this.featuresStd()[i];
                        sum += coefficientsArray[i] * featuresMean[i];
                        continue;
                    }
                    coefficientsArray[i] = 0.0;
                }
                double offset = this.fitIntercept ? this.labelMean / this.labelStd - sum : 0.0;
                this.effectiveCoefAndOffset = new Tuple2((Object)Vectors$.MODULE$.dense(coefficientsArray), (Object)BoxesRunTime.boxToDouble((double)offset));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.effectiveCoefAndOffset;
        }
    }

    private Vector effectiveCoefficientsVector$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.effectiveCoefficientsVector = (Vector)this.effectiveCoefAndOffset()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.effectiveCoefficientsVector;
        }
    }

    private double offset$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.offset = this.effectiveCoefAndOffset()._2$mcD$sp();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
            return this.offset;
        }
    }

    private double[] gradientSumArray$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if (!this.bitmap$0) {
                this.gradientSumArray = (double[])Array$.MODULE$.ofDim(this.dim(), ClassTag$.MODULE$.Double());
                this.bitmap$0 = true;
            }
            return this.gradientSumArray;
        }
    }

    private long totalCnt() {
        return this.totalCnt;
    }

    private void totalCnt_$eq(long x$1) {
        this.totalCnt = x$1;
    }

    public double org$apache$spark$ml$regression$LeastSquaresAggregator$$weightSum() {
        return this.org$apache$spark$ml$regression$LeastSquaresAggregator$$weightSum;
    }

    private void org$apache$spark$ml$regression$LeastSquaresAggregator$$weightSum_$eq(double x$1) {
        this.org$apache$spark$ml$regression$LeastSquaresAggregator$$weightSum = x$1;
    }

    private double lossSum() {
        return this.lossSum;
    }

    private void lossSum_$eq(double x$1) {
        this.lossSum = x$1;
    }

    private int dim() {
        return this.dim;
    }

    private double[] featuresStd() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.featuresStd$lzycompute() : this.featuresStd;
    }

    private Tuple2<Vector, Object> effectiveCoefAndOffset() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.effectiveCoefAndOffset$lzycompute() : this.effectiveCoefAndOffset;
    }

    private Vector effectiveCoefficientsVector() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.effectiveCoefficientsVector$lzycompute() : this.effectiveCoefficientsVector;
    }

    private double offset() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.offset$lzycompute() : this.offset;
    }

    private double[] gradientSumArray() {
        return this.bitmap$0 ? this.gradientSumArray : this.gradientSumArray$lzycompute();
    }

    public LeastSquaresAggregator add(Instance instance) {
        Instance instance2 = instance;
        if (instance2 != null) {
            double label = instance2.label();
            double weight = instance2.weight();
            Vector features = instance2.features();
            if (weight == 0.0) {
                return this;
            }
            double diff = BLAS$.MODULE$.dot(features, this.effectiveCoefficientsVector()) - label / this.labelStd + this.offset();
            if (diff != 0.0) {
                double[] localGradientSumArray = this.gradientSumArray();
                double[] localFeaturesStd = this.featuresStd();
                features.foreachActive((Function2)new Serializable(this, weight, diff, localGradientSumArray, localFeaturesStd){
                    public static final long serialVersionUID = 0L;
                    private final double weight$1;
                    private final double diff$1;
                    private final double[] localGradientSumArray$1;
                    private final double[] localFeaturesStd$1;

                    public final void apply(int index2, double value) {
                        this.apply$mcVID$sp(index2, value);
                    }

                    public void apply$mcVID$sp(int index2, double value) {
                        if (this.localFeaturesStd$1[index2] != 0.0 && value != 0.0) {
                            this.localGradientSumArray$1[index2] = this.localGradientSumArray$1[index2] + this.weight$1 * this.diff$1 * value / this.localFeaturesStd$1[index2];
                        }
                    }
                    {
                        this.weight$1 = weight$1;
                        this.diff$1 = diff$1;
                        this.localGradientSumArray$1 = localGradientSumArray$1;
                        this.localFeaturesStd$1 = localFeaturesStd$1;
                    }
                });
                this.lossSum_$eq(this.lossSum() + weight * diff * diff / 2.0);
            }
            this.totalCnt_$eq(this.totalCnt() + 1L);
            this.org$apache$spark$ml$regression$LeastSquaresAggregator$$weightSum_$eq(this.org$apache$spark$ml$regression$LeastSquaresAggregator$$weightSum() + weight);
            LeastSquaresAggregator leastSquaresAggregator = this;
            return leastSquaresAggregator;
        }
        throw new MatchError((Object)instance2);
    }

    public LeastSquaresAggregator merge(LeastSquaresAggregator other) {
        if (other.org$apache$spark$ml$regression$LeastSquaresAggregator$$weightSum() != 0.0) {
            this.totalCnt_$eq(this.totalCnt() + other.totalCnt());
            this.org$apache$spark$ml$regression$LeastSquaresAggregator$$weightSum_$eq(this.org$apache$spark$ml$regression$LeastSquaresAggregator$$weightSum() + other.org$apache$spark$ml$regression$LeastSquaresAggregator$$weightSum());
            this.lossSum_$eq(this.lossSum() + other.lossSum());
            double[] localThisGradientSumArray = this.gradientSumArray();
            double[] localOtherGradientSumArray = other.gradientSumArray();
            for (int i = 0; i < this.dim(); ++i) {
                int n = i;
                localThisGradientSumArray[n] = localThisGradientSumArray[n] + localOtherGradientSumArray[i];
            }
        }
        return this;
    }

    public long count() {
        return this.totalCnt();
    }

    public double loss() {
        Predef$.MODULE$.require(this.org$apache$spark$ml$regression$LeastSquaresAggregator$$weightSum() > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeastSquaresAggregator $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The effective number of instances should be "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"greater than 0.0, but ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$ml$regression$LeastSquaresAggregator$$weightSum())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return this.lossSum() / this.org$apache$spark$ml$regression$LeastSquaresAggregator$$weightSum();
    }

    /*
     * WARNING - void declaration
     */
    public Vector gradient() {
        void var1_1;
        Predef$.MODULE$.require(this.org$apache$spark$ml$regression$LeastSquaresAggregator$$weightSum() > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeastSquaresAggregator $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The effective number of instances should be "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"greater than 0.0, but ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$ml$regression$LeastSquaresAggregator$$weightSum())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Vector result = Vectors$.MODULE$.dense((double[])this.gradientSumArray().clone());
        BLAS$.MODULE$.scal(1.0 / this.org$apache$spark$ml$regression$LeastSquaresAggregator$$weightSum(), result);
        return var1_1;
    }

    public LeastSquaresAggregator(Broadcast<Vector> bcCoefficients, double labelStd, double labelMean, boolean fitIntercept, Broadcast<double[]> bcFeaturesStd, Broadcast<double[]> bcFeaturesMean) {
        this.bcCoefficients = bcCoefficients;
        this.labelStd = labelStd;
        this.labelMean = labelMean;
        this.fitIntercept = fitIntercept;
        this.bcFeaturesStd = bcFeaturesStd;
        this.bcFeaturesMean = bcFeaturesMean;
        this.totalCnt = 0L;
        this.org$apache$spark$ml$regression$LeastSquaresAggregator$$weightSum = 0.0;
        this.lossSum = 0.0;
        this.dim = ((Vector)bcCoefficients.value()).size();
    }
}

