/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.connector.hadoop.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.ImmutableContext;
import org.apache.sqoop.common.MutableContext;
import org.apache.sqoop.job.etl.TransferableContext;

public class SecurityUtils {
    private static final Logger LOG = Logger.getLogger(SecurityUtils.class);
    private static final String DELEGATION_TOKENS = "org.apache.sqoop.connector.delegation_tokens";

    public static UserGroupInformation createProxyUser(TransferableContext context) throws IOException {
        return UserGroupInformation.createProxyUser((String)context.getUser(), (UserGroupInformation)UserGroupInformation.getLoginUser());
    }

    public static UserGroupInformation createProxyUserAndLoadDelegationTokens(TransferableContext context) throws IOException {
        UserGroupInformation proxyUser = SecurityUtils.createProxyUser(context);
        SecurityUtils.loadDelegationTokensToUGI(proxyUser, context.getContext());
        return proxyUser;
    }

    public static void generateDelegationTokens(MutableContext context, Path path, Configuration configuration) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            LOG.info((Object)"Running on unsecured cluster, skipping delegation token generation.");
            return;
        }
        LinkedList<String> tokens = new LinkedList<String>();
        Credentials credentials = new Credentials();
        TokenCache.obtainTokensForNamenodes((Credentials)credentials, (Path[])new Path[]{path}, (Configuration)configuration);
        for (Token token : credentials.getAllTokens()) {
            LOG.info((Object)("Generated token: " + token.toString()));
            tokens.add(SecurityUtils.serializeToken(token));
        }
        if (tokens.size() > 0) {
            context.setString(DELEGATION_TOKENS, StringUtils.join(tokens, (String)" "));
        }
    }

    public static void loadDelegationTokensToUGI(UserGroupInformation ugi, ImmutableContext context) throws IOException {
        String tokenList = context.getString(DELEGATION_TOKENS);
        if (tokenList == null) {
            LOG.info((Object)"No delegation tokens found");
            return;
        }
        for (String stringToken : tokenList.split(" ")) {
            Token token = SecurityUtils.deserializeToken(stringToken);
            LOG.info((Object)("Loaded delegation token: " + token.toString()));
            ugi.addToken(token);
        }
    }

    public static String serializeToken(Token token) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        token.write((DataOutput)dos);
        baos.flush();
        return Base64.encodeBase64String((byte[])baos.toByteArray());
    }

    public static Token deserializeToken(String stringToken) throws IOException {
        Token token = new Token();
        byte[] tokenBytes = Base64.decodeBase64((String)stringToken);
        ByteArrayInputStream bais = new ByteArrayInputStream(tokenBytes);
        DataInputStream dis = new DataInputStream(bais);
        token.readFields((DataInput)dis);
        return token;
    }

    private SecurityUtils() {
    }
}

