/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cfg;

import java.util.ArrayList;
import java.util.Collection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ConfigurationLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.jta.JtaTransactionContextFactory;
import org.camunda.bpm.engine.impl.cfg.standalone.StandaloneTransactionContextFactory;
import org.camunda.bpm.engine.impl.interceptor.CommandContextFactory;
import org.camunda.bpm.engine.impl.interceptor.CommandContextInterceptor;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;
import org.camunda.bpm.engine.impl.interceptor.JtaTransactionInterceptor;
import org.camunda.bpm.engine.impl.interceptor.LogInterceptor;
import org.camunda.bpm.engine.impl.interceptor.ProcessApplicationContextInterceptor;
import org.camunda.bpm.engine.impl.interceptor.TxContextCommandContextFactory;

public class JtaProcessEngineConfiguration
extends ProcessEngineConfigurationImpl {
    private static final ConfigurationLogger LOG = ProcessEngineLogger.CONFIG_LOGGER;
    protected TransactionManager transactionManager;
    protected String transactionManagerJndiName;
    protected CommandContextFactory dbSchemaOperationsCommandContextFactory;

    public JtaProcessEngineConfiguration() {
        this.transactionsExternallyManaged = true;
    }

    @Override
    protected void init() {
        this.initTransactionManager();
        this.initDbSchemaOperationsCommandContextFactory();
        super.init();
    }

    @Override
    protected Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequired() {
        ArrayList<CommandInterceptor> defaultCommandInterceptorsTxRequired = new ArrayList<CommandInterceptor>();
        defaultCommandInterceptorsTxRequired.add(new LogInterceptor());
        defaultCommandInterceptorsTxRequired.add(new ProcessApplicationContextInterceptor(this));
        defaultCommandInterceptorsTxRequired.add(new JtaTransactionInterceptor(this.transactionManager, false));
        defaultCommandInterceptorsTxRequired.add(new CommandContextInterceptor(this.commandContextFactory, this));
        return defaultCommandInterceptorsTxRequired;
    }

    @Override
    protected Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequiresNew() {
        ArrayList<CommandInterceptor> defaultCommandInterceptorsTxRequiresNew = new ArrayList<CommandInterceptor>();
        defaultCommandInterceptorsTxRequiresNew.add(new LogInterceptor());
        defaultCommandInterceptorsTxRequiresNew.add(new ProcessApplicationContextInterceptor(this));
        defaultCommandInterceptorsTxRequiresNew.add(new JtaTransactionInterceptor(this.transactionManager, true));
        defaultCommandInterceptorsTxRequiresNew.add(new CommandContextInterceptor(this.commandContextFactory, this, true));
        return defaultCommandInterceptorsTxRequiresNew;
    }

    @Override
    protected void initCommandExecutorDbSchemaOperations() {
        if (this.commandExecutorSchemaOperations == null) {
            ArrayList<CommandInterceptor> commandInterceptorsDbSchemaOperations = new ArrayList<CommandInterceptor>();
            commandInterceptorsDbSchemaOperations.add(new LogInterceptor());
            commandInterceptorsDbSchemaOperations.add(new CommandContextInterceptor(this.dbSchemaOperationsCommandContextFactory, this));
            commandInterceptorsDbSchemaOperations.add(this.actualCommandExecutor);
            this.commandExecutorSchemaOperations = this.initInterceptorChain(commandInterceptorsDbSchemaOperations);
        }
    }

    protected void initDbSchemaOperationsCommandContextFactory() {
        if (this.dbSchemaOperationsCommandContextFactory == null) {
            TxContextCommandContextFactory cmdContextFactory = new TxContextCommandContextFactory();
            cmdContextFactory.setProcessEngineConfiguration(this);
            cmdContextFactory.setTransactionContextFactory(new StandaloneTransactionContextFactory());
            this.dbSchemaOperationsCommandContextFactory = cmdContextFactory;
        }
    }

    protected void initTransactionManager() {
        if (this.transactionManager == null) {
            if (this.transactionManagerJndiName == null || this.transactionManagerJndiName.length() == 0) {
                throw LOG.invalidConfigTransactionManagerIsNull();
            }
            try {
                this.transactionManager = (TransactionManager)new InitialContext().lookup(this.transactionManagerJndiName);
            }
            catch (NamingException e) {
                throw LOG.invalidConfigCannotFindTransactionManger(this.transactionManagerJndiName + "'.", e);
            }
        }
    }

    @Override
    protected void initTransactionContextFactory() {
        if (this.transactionContextFactory == null) {
            this.transactionContextFactory = new JtaTransactionContextFactory(this.transactionManager);
        }
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getTransactionManagerJndiName() {
        return this.transactionManagerJndiName;
    }

    public void setTransactionManagerJndiName(String transactionManagerJndiName) {
        this.transactionManagerJndiName = transactionManagerJndiName;
    }

    public CommandContextFactory getDbSchemaOperationsCommandContextFactory() {
        return this.dbSchemaOperationsCommandContextFactory;
    }

    public void setDbSchemaOperationsCommandContextFactory(CommandContextFactory dbSchemaOperationsCommandContextFactory) {
        this.dbSchemaOperationsCommandContextFactory = dbSchemaOperationsCommandContextFactory;
    }
}

