/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteHistoricProcessInstanceCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;

    public DeleteHistoricProcessInstanceCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("processInstanceId", (Object)this.processInstanceId);
        HistoricProcessInstanceEntity instance = commandContext.getHistoricProcessInstanceManager().findHistoricProcessInstance(this.processInstanceId);
        EnsureUtil.ensureNotNull("No historic process instance found with id: " + this.processInstanceId, "instance", (Object)instance);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteHistoricProcessInstance(instance);
        }
        EnsureUtil.ensureNotNull("Process instance is still running, cannot delete historic process instance: " + this.processInstanceId, "instance.getEndTime()", (Object)instance.getEndTime());
        commandContext.getHistoricProcessInstanceManager().deleteHistoricProcessInstanceById(this.processInstanceId);
        return null;
    }
}

