/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.ResolvableSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.ser.BeanPropertyWriter;
import org.codehaus.jackson.map.ser.SerializerBase;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.schema.JsonSchema;
import org.codehaus.jackson.schema.SchemaAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanSerializer
extends SerializerBase<Object>
implements ResolvableSerializer,
SchemaAware {
    static final BeanPropertyWriter[] NO_PROPS = new BeanPropertyWriter[0];
    protected final Class<?> _class;
    protected final BeanPropertyWriter[] _props;
    protected final BeanPropertyWriter[] _filteredProps;

    public BeanSerializer(Class<?> type, BeanPropertyWriter[] writers) {
        this(type, writers, null);
    }

    public BeanSerializer(Class<?> type, BeanPropertyWriter[] props, BeanPropertyWriter[] fprops) {
        this._props = props;
        this._class = type;
        this._filteredProps = fprops;
    }

    public BeanSerializer(Class<?> type, Collection<BeanPropertyWriter> props) {
        this(type, props.toArray(new BeanPropertyWriter[props.size()]));
    }

    public static BeanSerializer createDummy(Class<?> forType) {
        return new BeanSerializer(forType, NO_PROPS);
    }

    public BeanSerializer withFiltered(BeanPropertyWriter[] filtered) {
        if (filtered == null) {
            return this;
        }
        return new BeanSerializer(this._class, this._props, filtered);
    }

    @Override
    public void serialize(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        int i;
        BeanPropertyWriter[] props = this._filteredProps != null && provider.getSerializationView() != null ? this._filteredProps : this._props;
        jgen.writeStartObject();
        try {
            for (BeanPropertyWriter prop : props) {
                if (prop == null) continue;
                prop.serializeAsField(bean, jgen, provider);
            }
            jgen.writeEndObject();
        }
        catch (Exception e) {
            this.wrapAndThrow((Throwable)e, bean, props[i].getName());
        }
        catch (StackOverflowError e) {
            JsonMappingException mapE = new JsonMappingException("Infinite recursion (StackOverflowError)");
            mapE.prependPath(new JsonMappingException.Reference(bean, props[i].getName()));
            throw mapE;
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        ObjectNode o = this.createSchemaNode("object", true);
        ObjectNode propertiesNode = o.objectNode();
        for (int i = 0; i < this._props.length; ++i) {
            JsonSerializer<Object> ser;
            BeanPropertyWriter prop = this._props[i];
            Type hint = prop.getSerializationType();
            if (hint == null) {
                hint = prop.getGenericPropertyType();
            }
            if ((ser = prop.getSerializer()) == null) {
                Class<?> serType = prop.getSerializationType();
                if (serType == null) {
                    serType = prop.getReturnType();
                }
                ser = provider.findValueSerializer(serType);
            }
            JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, hint) : JsonSchema.getDefaultSchemaNode();
            o.put("items", schemaNode);
            propertiesNode.put(prop.getName(), schemaNode);
        }
        o.put("properties", propertiesNode);
        return o;
    }

    @Override
    public void resolve(SerializerProvider provider) throws JsonMappingException {
        for (BeanPropertyWriter prop : this._props) {
            if (prop.hasSerializer()) continue;
            Class<?> type = prop.getSerializationType();
            if (type == null) {
                Class<?> rt = prop.getReturnType();
                if (!Modifier.isFinal(rt.getModifiers())) continue;
                type = rt;
            }
            this._props[i] = prop.withSerializer(provider.findValueSerializer(type));
        }
    }

    public String toString() {
        return "BeanSerializer for " + this._class.getName();
    }
}

