/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.version;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.codehaus.plexus.languages.java.version.JavaClassfileVersionParser;
import org.codehaus.plexus.languages.java.version.JavaVersion;

public final class JavaClassfileVersion {
    private final int major;
    private final int minor;

    JavaClassfileVersion(int major, int minor) {
        if (major < 45) {
            throw new IllegalArgumentException("Java class major version must be 45 or above.");
        }
        this.major = major;
        this.minor = minor;
    }

    public static JavaClassfileVersion of(byte[] bytes) {
        return JavaClassfileVersionParser.of(bytes);
    }

    public static JavaClassfileVersion of(Path path) {
        try {
            byte[] readAllBytes = Files.readAllBytes(path);
            return JavaClassfileVersion.of(readAllBytes);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public JavaVersion javaVersion() {
        int javaVer = this.major - 44;
        String javaVersion = javaVer < 9 ? "1." + javaVer : Integer.toString(javaVer);
        return JavaVersion.parse(javaVersion);
    }

    public int majorVersion() {
        return this.major;
    }

    public int minorVersion() {
        return this.minor;
    }

    public boolean isPreview() {
        return this.minor == 65535;
    }

    public String toString() {
        return this.major + "." + this.minor + " (Java " + this.javaVersion() + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaClassfileVersion)) {
            return false;
        }
        JavaClassfileVersion other = (JavaClassfileVersion)obj;
        if (this.major != other.major) {
            return false;
        }
        return this.minor == other.minor;
    }
}

