/*
 * Decompiled with CFR 0.152.
 */
package com.coverity.security;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Filter {
    private static final Pattern OCTAL_REGEX = Pattern.compile("(0+)([0-7]*)");
    private static final Pattern NUMBER_REGEX = Pattern.compile("[-+]?((\\.[0-9]+)|([0-9]+\\.?[0-9]*))");
    private static final Pattern HEX_REGEX = Pattern.compile("0x[0-9a-fA-F]+");
    private static final Pattern CSS_HEX_COLOR_REGEX = Pattern.compile("#[0-9a-fA-F]{3}([0-9a-fA-F]{3})?");
    private static final Pattern CSS_NAMED_COLOR_REGEX = Pattern.compile("[a-zA-Z]{1,20}");
    private static final Pattern URL_REGEX = Pattern.compile("(/|\\\\\\\\|https?:|ftp:|mailto:).*", 2);
    private static final Pattern SCHEME_REGEX = Pattern.compile("(javascript|vbscript|data|about)");

    public static String asNumber(String number) {
        return Filter.asNumber(number, "0");
    }

    public static String asNumber(String number, String defaultNumber) {
        if (number == null) {
            return null;
        }
        String trimNumber = number.trim();
        Matcher octal = OCTAL_REGEX.matcher(trimNumber);
        if (octal.matches()) {
            return octal.group(2);
        }
        if (NUMBER_REGEX.matcher(trimNumber).matches()) {
            return trimNumber;
        }
        if (HEX_REGEX.matcher(trimNumber).matches()) {
            return trimNumber;
        }
        return defaultNumber;
    }

    public static String asCssColor(String color) {
        return Filter.asCssColor(color, "invalid");
    }

    public static String asCssColor(String color, String defaultColor) {
        if (color == null) {
            return null;
        }
        if (CSS_HEX_COLOR_REGEX.matcher(color).matches()) {
            return color;
        }
        if (CSS_NAMED_COLOR_REGEX.matcher(color).matches()) {
            return color;
        }
        return defaultColor;
    }

    public static String asURL(String url) {
        if (url == null) {
            return null;
        }
        if (url.length() == 0) {
            return url;
        }
        if (URL_REGEX.matcher(url).matches()) {
            return url;
        }
        return "./" + url;
    }

    public static String asFlexibleURL(String url) {
        char c;
        int i;
        if (url == null) {
            return null;
        }
        int length = url.length();
        if (url.startsWith("/")) {
            return url;
        }
        if (url.startsWith("\\\\")) {
            return url;
        }
        for (i = 0; i < length && ((c = url.charAt(i)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '+' || c == '-'); ++i) {
        }
        if (i == length) {
            return url;
        }
        if (url.charAt(i) == ':' && Filter.validateScheme(url.substring(0, i).toLowerCase())) {
            return url;
        }
        return "./" + url;
    }

    private static boolean validateScheme(String scheme) {
        return !SCHEME_REGEX.matcher(scheme).matches();
    }
}

