/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.tencent.service;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.dromara.sms4j.tencent.config.TencentConfig;
import org.dromara.sms4j.tencent.utils.TencentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TencentSmsImpl
extends AbstractSmsBlend<TencentConfig> {
    private static final Logger log = LoggerFactory.getLogger(TencentSmsImpl.class);
    private int retry = 0;

    public TencentSmsImpl(TencentConfig tencentSmsConfig, Executor pool, DelayedTime delayed) {
        super(tencentSmsConfig, pool, delayed);
    }

    public TencentSmsImpl(TencentConfig tencentSmsConfig) {
        super(tencentSmsConfig);
    }

    public String getSupplier() {
        return "tencent";
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        String[] split = message.split("&");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < split.length; ++i) {
            map.put(String.valueOf(i), split[i]);
        }
        return this.sendMessage(phone, ((TencentConfig)this.getConfig()).getTemplateId(), map);
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            list.add(entry.getValue());
        }
        String[] s = new String[list.size()];
        return this.getSmsResponse(new String[]{StrUtil.addPrefixIfNot((CharSequence)phone, (CharSequence)"+86")}, list.toArray(s), templateId);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        String[] split = message.split("&");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < split.length; ++i) {
            map.put(String.valueOf(i), split[i]);
        }
        return this.massTexting(phones, ((TencentConfig)this.getConfig()).getTemplateId(), map);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            list.add(entry.getValue());
        }
        String[] s = new String[list.size()];
        return this.getSmsResponse(SmsUtils.listToArray(phones), list.toArray(s), templateId);
    }

    private SmsResponse getSmsResponse(String[] phones, String[] messages, String templateId) {
        String signature;
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        try {
            signature = TencentUtils.generateSignature((TencentConfig)this.getConfig(), templateId, messages, phones, timestamp);
        }
        catch (Exception e) {
            log.error("tencent send message error", (Throwable)e);
            throw new SmsBlendException(e.getMessage());
        }
        Map<String, String> headsMap = TencentUtils.generateHeadsMap(signature, timestamp, ((TencentConfig)this.getConfig()).getAction(), ((TencentConfig)this.getConfig()).getVersion(), ((TencentConfig)this.getConfig()).getTerritory(), ((TencentConfig)this.getConfig()).getRequestUrl());
        Map<String, Object> requestBody = TencentUtils.generateRequestBody(phones, ((TencentConfig)this.getConfig()).getSdkAppId(), ((TencentConfig)this.getConfig()).getSignature(), templateId, messages);
        String url = "https://" + ((TencentConfig)this.getConfig()).getRequestUrl();
        try {
            SmsResponse smsResponse = this.getResponse(this.http.postJson(url, headsMap, requestBody));
            if (smsResponse.isSuccess() || this.retry == ((TencentConfig)this.getConfig()).getMaxRetries()) {
                this.retry = 0;
                return smsResponse;
            }
            return this.requestRetry(phones, messages, templateId);
        }
        catch (SmsBlendException e) {
            return this.requestRetry(phones, messages, templateId);
        }
    }

    private SmsResponse requestRetry(String[] phones, String[] messages, String templateId) {
        this.http.safeSleep(((TencentConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {" + this.retry + "} \u6b21\u91cd\u65b0\u53d1\u9001");
        return this.getSmsResponse(phones, messages, templateId);
    }

    private SmsResponse getResponse(JSONObject resJson) {
        SmsResponse smsResponse = new SmsResponse();
        JSONObject response = resJson.getJSONObject((Object)"Response");
        String error = response.getStr((Object)"Error");
        smsResponse.setSuccess(StrUtil.isBlank((CharSequence)error));
        JSONArray sendStatusSet = response.getJSONArray((Object)"SendStatusSet");
        if (sendStatusSet != null) {
            boolean success = true;
            for (Object obj : sendStatusSet) {
                JSONObject jsonObject = (JSONObject)obj;
                String code = jsonObject.getStr((Object)"Code");
                if ("Ok".equals(code)) continue;
                success = false;
                break;
            }
            smsResponse.setSuccess(success);
        }
        smsResponse.setData((Object)resJson);
        smsResponse.setConfigId(this.getConfigId());
        return smsResponse;
    }
}

