/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.converter.child;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DmnElement;
import org.flowable.dmn.xml.constants.DmnXMLConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseChildElementParser
implements DmnXMLConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseChildElementParser.class);

    public abstract String getElementName();

    public abstract void parseChildElement(XMLStreamReader var1, DmnElement var2, Decision var3) throws Exception;

    protected void parseChildElements(XMLStreamReader xtr, DmnElement parentElement, Decision decision, BaseChildElementParser parser) throws Exception {
        boolean readyWithChildElements = false;
        while (!readyWithChildElements && xtr.hasNext()) {
            xtr.next();
            if (xtr.isStartElement()) {
                if (!parser.getElementName().equals(xtr.getLocalName())) continue;
                parser.parseChildElement(xtr, parentElement, decision);
                continue;
            }
            if (!xtr.isEndElement() || !this.getElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
            readyWithChildElements = true;
        }
    }

    public boolean accepts(DmnElement element) {
        return element != null;
    }

    public List<Object> splitAndFormatInputOutputValues(String valuesText) {
        int subEnd;
        int subStart;
        if (StringUtils.isEmpty((CharSequence)valuesText)) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int start = 0;
        boolean inQuotes = false;
        for (int current = 0; current < valuesText.length(); ++current) {
            if (valuesText.charAt(current) == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (valuesText.charAt(current) != ',' || inQuotes) continue;
            subStart = this.getSubStringStartPos(start, valuesText);
            subEnd = this.getSubStringEndPos(current, valuesText);
            result.add(valuesText.substring(subStart, subEnd));
            start = current + 1;
            if (valuesText.charAt(start) != ' ') continue;
            ++start;
        }
        subStart = this.getSubStringStartPos(start, valuesText);
        subEnd = this.getSubStringEndPos(valuesText.length(), valuesText);
        result.add(valuesText.substring(subStart, subEnd));
        return result;
    }

    protected int getSubStringStartPos(int initialStart, String searchString) {
        if (searchString.charAt(initialStart) == '\"') {
            return initialStart + 1;
        }
        return initialStart;
    }

    protected int getSubStringEndPos(int initialEnd, String searchString) {
        if (searchString.charAt(initialEnd - 1) == '\"') {
            return initialEnd - 1;
        }
        return initialEnd;
    }
}

