/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import org.flowable.bpmn.model.FlowNode;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.agenda.ContinueProcessOperation;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.ProcessDebugger;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.job.service.impl.persistence.entity.JobEntity;

public class DebugContinueProcessOperation
extends ContinueProcessOperation {
    public static final String HANDLER_TYPE_BREAK_POINT = "breakpoint";
    protected ProcessDebugger debugger;

    public DebugContinueProcessOperation(ProcessDebugger debugger, CommandContext commandContext, ExecutionEntity execution, boolean forceSynchronousOperation, boolean inCompensation) {
        super(commandContext, execution, forceSynchronousOperation, inCompensation);
        this.debugger = debugger;
    }

    public DebugContinueProcessOperation(ProcessDebugger debugger, CommandContext commandContext, ExecutionEntity execution) {
        super(commandContext, execution);
        this.debugger = debugger;
    }

    @Override
    protected void continueThroughFlowNode(FlowNode flowNode) {
        if (this.debugger.isBreakpoint(this.execution)) {
            this.breakExecution(flowNode);
        } else {
            super.continueThroughFlowNode(flowNode);
        }
    }

    protected void breakExecution(FlowNode flowNode) {
        JobService jobService = CommandContextUtil.getJobService();
        JobEntity brokenJob = jobService.createJob();
        brokenJob.setJobType("message");
        brokenJob.setRevision(1);
        brokenJob.setRetries(1);
        brokenJob.setExecutionId(this.execution.getId());
        brokenJob.setProcessInstanceId(this.execution.getProcessInstanceId());
        brokenJob.setProcessDefinitionId(this.execution.getProcessDefinitionId());
        brokenJob.setExclusive(false);
        brokenJob.setJobHandlerType(HANDLER_TYPE_BREAK_POINT);
        if (this.execution.getTenantId() != null) {
            brokenJob.setTenantId(this.execution.getTenantId());
        }
        jobService.insertJob(brokenJob);
        jobService.moveJobToSuspendedJob((AbstractRuntimeJobEntity)brokenJob);
    }
}

