/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.asyncexecutor.message;

import java.util.List;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.engine.impl.asyncexecutor.message.AsyncJobMessageHandler;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.JobQueryImpl;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.JobEntityManager;

public class AsyncJobMessageReceiver {
    protected JobServiceConfiguration jobServiceConfiguration;
    protected AsyncJobMessageHandler asyncJobMessageHandler;

    public AsyncJobMessageReceiver() {
    }

    public AsyncJobMessageReceiver(JobServiceConfiguration jobServiceConfiguration, AsyncJobMessageHandler asyncJobMessageHandler) {
        this.jobServiceConfiguration = jobServiceConfiguration;
        this.asyncJobMessageHandler = asyncJobMessageHandler;
    }

    public void messageForJobReceived(final String jobId) {
        if (this.jobServiceConfiguration == null) {
            throw new FlowableException("Programmatic error: this class needs a JobServiceEngineConfiguration instance");
        }
        if (this.asyncJobMessageHandler == null) {
            throw new FlowableException("Programmatic error: this class needs an AsyncJobMessageHandler instance.");
        }
        this.jobServiceConfiguration.getCommandExecutor().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobEntityManager jobEntityManager = AsyncJobMessageReceiver.this.jobServiceConfiguration.getJobEntityManager();
                JobQueryImpl query = new JobQueryImpl();
                query.jobId(jobId);
                List jobs = jobEntityManager.findJobsByQueryCriteria(query);
                if (jobs == null || jobs.isEmpty()) {
                    throw new FlowableException("No job found for job id " + jobId);
                }
                if (jobs.size() > 1) {
                    throw new FlowableException("Multiple results for job id " + jobId);
                }
                if (!(jobs.get(0) instanceof JobEntity)) {
                    throw new FlowableException("Job with id " + jobId + " is not an instance of job entity, cannot handle this job");
                }
                JobEntity jobEntity = (JobEntity)jobs.get(0);
                if (AsyncJobMessageReceiver.this.asyncJobMessageHandler.handleJob(jobEntity)) {
                    jobEntityManager.delete((Entity)jobEntity);
                }
                return null;
            }
        });
    }

    public JobServiceConfiguration getJobServiceConfiguration() {
        return this.jobServiceConfiguration;
    }

    public void setJobServiceConfiguration(JobServiceConfiguration jobServiceConfiguration) {
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public AsyncJobMessageHandler getAsyncJobMessageHandler() {
        return this.asyncJobMessageHandler;
    }

    public void setAsyncJobMessageHandler(AsyncJobMessageHandler asyncJobMessageHandler) {
        this.asyncJobMessageHandler = asyncJobMessageHandler;
    }
}

