/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.ValuedDataObject;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.DataObjectImpl;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.runtime.DataObject;
import org.flowable.engine.runtime.Execution;
import org.flowable.variable.api.persistence.entity.VariableInstance;

public class GetDataObjectsCmd
implements Command<Map<String, DataObject>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected Collection<String> dataObjectNames;
    protected boolean isLocal;
    protected String locale;
    protected boolean withLocalizationFallback;

    public GetDataObjectsCmd(String executionId, Collection<String> dataObjectNames, boolean isLocal) {
        this.executionId = executionId;
        this.dataObjectNames = dataObjectNames;
        this.isLocal = isLocal;
    }

    public GetDataObjectsCmd(String executionId, Collection<String> dataObjectNames, boolean isLocal, String locale, boolean withLocalizationFallback) {
        this.executionId = executionId;
        this.dataObjectNames = dataObjectNames;
        this.isLocal = isLocal;
        this.locale = locale;
        this.withLocalizationFallback = withLocalizationFallback;
    }

    public Map<String, DataObject> execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new FlowableIllegalArgumentException("executionId is null");
        }
        ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(this.executionId);
        if (execution == null) {
            throw new FlowableObjectNotFoundException("execution " + this.executionId + " doesn't exist", Execution.class);
        }
        Map variables = null;
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            variables = compatibilityHandler.getExecutionVariableInstances(this.executionId, this.dataObjectNames, this.isLocal);
        } else {
            variables = this.dataObjectNames == null || this.dataObjectNames.isEmpty() ? (this.isLocal ? execution.getVariableInstancesLocal() : execution.getVariableInstances()) : (this.isLocal ? execution.getVariableInstancesLocal(this.dataObjectNames, false) : execution.getVariableInstances(this.dataObjectNames, false));
        }
        HashMap<String, DataObjectImpl> dataObjects = null;
        if (variables != null) {
            dataObjects = new HashMap<String, DataObjectImpl>(variables.size());
            for (Map.Entry entry : variables.entrySet()) {
                ObjectNode languageNode;
                String name = (String)entry.getKey();
                VariableInstance variableEntity = (VariableInstance)entry.getValue();
                ExecutionEntity executionEntity = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(variableEntity.getExecutionId());
                while (!executionEntity.isScope()) {
                    executionEntity = executionEntity.getParent();
                }
                BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId());
                ValuedDataObject foundDataObject = null;
                if (executionEntity.getParentId() == null) {
                    for (ValuedDataObject dataObject : bpmnModel.getMainProcess().getDataObjects()) {
                        if (!dataObject.getName().equals(variableEntity.getName())) continue;
                        foundDataObject = dataObject;
                        break;
                    }
                } else {
                    ValuedDataObject dataObject;
                    SubProcess subProcess = (SubProcess)bpmnModel.getFlowElement(executionEntity.getActivityId());
                    dataObject = subProcess.getDataObjects().iterator();
                    while (dataObject.hasNext()) {
                        ValuedDataObject dataObject2 = (ValuedDataObject)dataObject.next();
                        if (!dataObject2.getName().equals(variableEntity.getName())) continue;
                        foundDataObject = dataObject2;
                        break;
                    }
                }
                String localizedName = null;
                String localizedDescription = null;
                if (this.locale != null && foundDataObject != null && (languageNode = BpmnOverrideContext.getLocalizationElementProperties(this.locale, foundDataObject.getId(), execution.getProcessDefinitionId(), this.withLocalizationFallback)) != null) {
                    JsonNode descriptionNode;
                    JsonNode nameNode = languageNode.get("name");
                    if (nameNode != null) {
                        localizedName = nameNode.asText();
                    }
                    if ((descriptionNode = languageNode.get("description")) != null) {
                        localizedDescription = descriptionNode.asText();
                    }
                }
                if (foundDataObject == null) continue;
                dataObjects.put(name, new DataObjectImpl(variableEntity.getId(), variableEntity.getProcessInstanceId(), variableEntity.getExecutionId(), variableEntity.getName(), variableEntity.getValue(), foundDataObject.getDocumentation(), foundDataObject.getType(), localizedName, localizedDescription, foundDataObject.getId()));
            }
        }
        return dataObjects;
    }
}

