/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.form.api.FormFieldHandler;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormService;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.flowable.variable.api.history.HistoricVariableInstance;

public class GetTaskFormModelCmd
implements Command<FormInfo>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public GetTaskFormModelCmd(String taskId) {
        this.taskId = taskId;
    }

    public FormInfo execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        FormService formService = CommandContextUtil.getFormService();
        if (formService == null) {
            throw new FlowableIllegalArgumentException("Form engine is not initialized");
        }
        HistoricTaskInstanceEntity task = CommandContextUtil.getHistoricTaskService().getHistoricTask(this.taskId);
        if (task == null) {
            throw new FlowableObjectNotFoundException("Task not found with id " + this.taskId);
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (task.getProcessInstanceId() != null) {
            List variableInstances = processEngineConfiguration.getHistoryService().createHistoricVariableInstanceQuery().processInstanceId(task.getProcessInstanceId()).list();
            for (HistoricVariableInstance historicVariableInstance : variableInstances) {
                variables.put(historicVariableInstance.getVariableName(), historicVariableInstance.getValue());
            }
        }
        String parentDeploymentId = null;
        if (StringUtils.isNotEmpty((CharSequence)task.getProcessDefinitionId())) {
            ProcessDefinition processDefinition = processEngineConfiguration.getRepositoryService().getProcessDefinition(task.getProcessDefinitionId());
            parentDeploymentId = processDefinition.getDeploymentId();
        }
        Object formInfo = null;
        formInfo = task.getEndTime() != null ? formService.getFormInstanceModelByKeyAndParentDeploymentId(task.getFormKey(), parentDeploymentId, this.taskId, task.getProcessInstanceId(), variables, task.getTenantId()) : formService.getFormModelWithVariablesByKeyAndParentDeploymentId(task.getFormKey(), parentDeploymentId, this.taskId, variables, task.getTenantId());
        if (formInfo == null) {
            throw new FlowableObjectNotFoundException("Form model for task " + task.getTaskDefinitionKey() + " cannot be found for form key " + task.getFormKey());
        }
        FormFieldHandler formFieldHandler = CommandContextUtil.getProcessEngineConfiguration(commandContext).getFormFieldHandler();
        formFieldHandler.enrichFormFields(formInfo);
        return formInfo;
    }
}

