/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.dynamic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.IOParameter;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.ValuedDataObject;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.delegate.Expression;
import org.flowable.engine.common.api.delegate.event.FlowableEngineEventType;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEventDispatcher;
import org.flowable.engine.common.api.variable.VariableContainer;
import org.flowable.engine.common.impl.el.ExpressionManager;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.util.CollectionUtil;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.dynamic.DynamicStateManager;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.dynamic.MoveExecutionEntityContainer;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.ProcessInstanceHelper;
import org.flowable.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDynamicStateManager
implements DynamicStateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDynamicStateManager.class);

    @Override
    public ExecutionEntity resolveActiveExecution(String executionId, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExecutionEntity execution = (ExecutionEntity)executionEntityManager.findById(executionId);
        if (execution == null) {
            throw new FlowableException("Execution could not be found with id " + executionId);
        }
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
            throw new FlowableException("Flowable 5 process definitions are not supported");
        }
        return execution;
    }

    @Override
    public ExecutionEntity resolveActiveExecution(String processInstanceId, String activityId, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExecutionEntity processExecution = (ExecutionEntity)executionEntityManager.findById(processInstanceId);
        if (processExecution == null) {
            throw new FlowableException("Execution could not be found with id " + processInstanceId);
        }
        if (!processExecution.isProcessInstanceType()) {
            throw new FlowableException("Execution is not a process instance type execution for id " + processInstanceId);
        }
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, processExecution.getProcessDefinitionId())) {
            throw new FlowableException("Flowable 5 process definitions are not supported");
        }
        ExecutionEntity execution = this.getActiveExecution(activityId, processExecution, commandContext);
        return execution;
    }

    @Override
    public void moveExecutionState(List<MoveExecutionEntityContainer> moveExecutionEntityContainerList, Map<String, Object> processVariables, Map<String, Map<String, Object>> localVariables, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        for (MoveExecutionEntityContainer moveExecutionContainer : moveExecutionEntityContainerList) {
            FlowElement moveToFlowElement;
            for (String activityId : moveExecutionContainer.getMoveToActivityIds()) {
                ExecutionEntity firstExecution;
                BpmnModel bpmnModel = null;
                if (moveExecutionContainer.isMoveToParentProcess()) {
                    String parentProcessDefinitionId = moveExecutionContainer.getSuperExecution().getProcessDefinitionId();
                    bpmnModel = ProcessDefinitionUtil.getBpmnModel(parentProcessDefinitionId);
                } else if (moveExecutionContainer.isMoveToSubProcessInstance()) {
                    firstExecution = moveExecutionContainer.getExecutions().get(0);
                    bpmnModel = ProcessDefinitionUtil.getBpmnModel(firstExecution.getProcessDefinitionId());
                    FlowElement callActivityElement = bpmnModel.getFlowElement(moveExecutionContainer.getCallActivityId());
                    if (callActivityElement == null) {
                        throw new FlowableException("Call activity could not be found in process definition for id " + activityId);
                    }
                    CallActivity callActivity = (CallActivity)callActivityElement;
                    moveExecutionContainer.setCallActivity(callActivity);
                    ProcessDefinition subProcessDefinition = null;
                    if (callActivity.isSameDeployment()) {
                        ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition(firstExecution.getProcessDefinitionId());
                        ProcessDefinitionEntityManager processDefinitionEntityManager = CommandContextUtil.getProcessDefinitionEntityManager(commandContext);
                        subProcessDefinition = firstExecution.getTenantId() == null || "".equals(firstExecution.getTenantId()) ? processDefinitionEntityManager.findProcessDefinitionByDeploymentAndKey(processDefinition.getDeploymentId(), callActivity.getCalledElement()) : processDefinitionEntityManager.findProcessDefinitionByDeploymentAndKeyAndTenantId(processDefinition.getDeploymentId(), callActivity.getCalledElement(), firstExecution.getTenantId());
                    }
                    if (subProcessDefinition == null) {
                        subProcessDefinition = firstExecution.getTenantId() == null || "".equals(firstExecution.getTenantId()) ? CommandContextUtil.getProcessEngineConfiguration().getDeploymentManager().findDeployedLatestProcessDefinitionByKey(callActivity.getCalledElement()) : CommandContextUtil.getProcessEngineConfiguration().getDeploymentManager().findDeployedLatestProcessDefinitionByKeyAndTenantId(callActivity.getCalledElement(), firstExecution.getTenantId());
                    }
                    BpmnModel subProcessModel = ProcessDefinitionUtil.getBpmnModel(subProcessDefinition.getId());
                    moveExecutionContainer.setSubProcessDefinition(subProcessDefinition);
                    moveExecutionContainer.setSubProcessModel(subProcessModel);
                    FlowElement newFlowElement = subProcessModel.getFlowElement(activityId);
                    if (newFlowElement == null) {
                        throw new FlowableException("Activity could not be found in sub process definition for id " + activityId);
                    }
                    moveExecutionContainer.addMoveToFlowElement(activityId, newFlowElement);
                } else {
                    firstExecution = moveExecutionContainer.getExecutions().get(0);
                    bpmnModel = ProcessDefinitionUtil.getBpmnModel(firstExecution.getProcessDefinitionId());
                }
                if (moveExecutionContainer.isMoveToSubProcessInstance()) continue;
                FlowElement newFlowElement = bpmnModel.getFlowElement(activityId);
                if (newFlowElement == null) {
                    throw new FlowableException("Activity could not be found in process definition for id " + activityId);
                }
                moveExecutionContainer.addMoveToFlowElement(activityId, newFlowElement);
            }
            if (moveExecutionContainer.isMoveToParentProcess()) {
                ExecutionEntity firstExecution = moveExecutionContainer.getExecutions().get(0);
                List<ExecutionEntity> subProcessExecutions = executionEntityManager.findChildExecutionsByProcessInstanceId(firstExecution.getProcessInstanceId());
                Iterator<ExecutionEntity> executionIds = new ArrayList();
                for (ExecutionEntity execution : moveExecutionContainer.getExecutions()) {
                    executionIds.add((ExecutionEntity)((Object)execution.getId()));
                }
                for (ExecutionEntity subProcessExecution : subProcessExecutions) {
                    if (executionIds.contains(subProcessExecution.getId())) continue;
                    throw new FlowableException("Execution of sub process instance is not moved " + subProcessExecution.getId());
                }
                executionEntityManager.deleteProcessInstance(firstExecution.getProcessInstanceId(), "Change activity to parent process activity ids: " + this.printFlowElementIds(moveExecutionContainer.getMoveToFlowElements()), true);
            }
            List<ExecutionEntity> currentExecutions = null;
            currentExecutions = moveExecutionContainer.isMoveToParentProcess() ? Collections.singletonList(moveExecutionContainer.getSuperExecution()) : moveExecutionContainer.getExecutions();
            Collection<Object> moveToFlowElements = null;
            moveToFlowElements = moveExecutionContainer.isMoveToSubProcessInstance() ? Collections.singletonList(moveExecutionContainer.getCallActivity()) : moveExecutionContainer.getMoveToFlowElements();
            for (ExecutionEntity execution : currentExecutions) {
                if (execution.getParentId() == null) {
                    throw new FlowableException("Execution has no parent execution " + execution.getParentId());
                }
                ExecutionEntity continueParentExecution = this.deleteParentExecutions(execution.getParentId(), moveToFlowElements, commandContext);
                moveExecutionContainer.addContinueParentExecution(execution.getId(), continueParentExecution);
            }
            for (ExecutionEntity execution : currentExecutions) {
                executionEntityManager.deleteExecutionAndRelatedData(execution, "Change activity to " + this.printFlowElementIds(moveToFlowElements));
            }
            List<ExecutionEntity> newChildExecutions = this.createEmbeddedSubProcessExecutions(moveToFlowElements, currentExecutions, moveExecutionContainer, commandContext);
            ExecutionEntity defaultContinueParentExecution = null;
            if (moveExecutionContainer.isMoveToSubProcessInstance()) {
                CallActivity callActivity = moveExecutionContainer.getCallActivity();
                Process subProcess = moveExecutionContainer.getSubProcessModel().getProcessById(callActivity.getCalledElement());
                ExecutionEntity subProcessChildExecution = this.createSubProcessInstance(callActivity, moveExecutionContainer.getSubProcessDefinition(), newChildExecutions.get(0), subProcess.getInitialFlowElement(), commandContext);
                List<ExecutionEntity> currentSubProcessExecutions = Collections.singletonList(subProcessChildExecution);
                MoveExecutionEntityContainer subProcessMoveExecutionEntityContainer = new MoveExecutionEntityContainer(currentSubProcessExecutions, moveExecutionContainer.getMoveToActivityIds());
                subProcessMoveExecutionEntityContainer.addMoveToFlowElement(callActivity.getId(), (FlowElement)callActivity);
                ExecutionEntity continueParentExecution = this.deleteParentExecutions(subProcessChildExecution.getParentId(), moveExecutionContainer.getMoveToFlowElements(), commandContext);
                subProcessMoveExecutionEntityContainer.addContinueParentExecution(subProcessChildExecution.getId(), continueParentExecution);
                executionEntityManager.deleteExecutionAndRelatedData(subProcessChildExecution, "Change activity to " + this.printFlowElementIds(moveToFlowElements));
                newChildExecutions = this.createEmbeddedSubProcessExecutions(moveExecutionContainer.getMoveToFlowElements(), currentSubProcessExecutions, subProcessMoveExecutionEntityContainer, commandContext);
                defaultContinueParentExecution = newChildExecutions.get(0);
            } else {
                defaultContinueParentExecution = moveExecutionContainer.getContinueParentExecution(currentExecutions.get(0).getId());
            }
            if (processVariables != null && processVariables.size() > 0) {
                ExecutionEntity processInstanceExecution = defaultContinueParentExecution.getProcessInstance();
                processInstanceExecution.setVariables(processVariables);
            }
            if (moveExecutionContainer.getMoveToFlowElements().size() == 1 && localVariables != null && localVariables.size() > 0 && localVariables.containsKey((moveToFlowElement = moveExecutionContainer.getMoveToFlowElements().iterator().next()).getId())) {
                List<SubProcess> toCreateSubProcesses = moveExecutionContainer.getSubProcessesToCreateMap().get(moveToFlowElement.getId());
                if (toCreateSubProcesses != null && toCreateSubProcesses.size() > 0) {
                    moveExecutionContainer.getNewSubProcessChildExecution(toCreateSubProcesses.get(0).getId()).setVariablesLocal(localVariables.get(moveToFlowElement.getId()));
                } else {
                    newChildExecutions.get(0).setVariablesLocal(localVariables.get(moveToFlowElement.getId()));
                }
            }
            for (ExecutionEntity newChildExecution : newChildExecutions) {
                CommandContextUtil.getAgenda().planContinueProcessOperation(newChildExecution);
            }
        }
    }

    protected List<ExecutionEntity> createEmbeddedSubProcessExecutions(Collection<FlowElement> moveToFlowElements, List<ExecutionEntity> currentExecutions, MoveExecutionEntityContainer moveExecutionContainer, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        for (FlowElement flowElement : moveToFlowElements) {
            this.resolveSubProcesExecutionsToCreate(flowElement.getId(), flowElement.getSubProcess(), currentExecutions, moveExecutionContainer);
        }
        ExecutionEntity defaultContinueParentExecution = moveExecutionContainer.getContinueParentExecution(currentExecutions.get(0).getId());
        for (String activityId : moveExecutionContainer.getSubProcessesToCreateMap().keySet()) {
            List<SubProcess> subProcessesToCreate = moveExecutionContainer.getSubProcessesToCreateMap().get(activityId);
            for (SubProcess subProcess : subProcessesToCreate) {
                if (moveExecutionContainer.getNewSubProcessChildExecution(subProcess.getId()) != null) continue;
                FlowElement startElement = this.getStartElement(subProcess);
                if (startElement == null) {
                    throw new FlowableException("No initial activity found for subprocess " + subProcess.getId());
                }
                ExecutionEntity subProcessExecution = executionEntityManager.createChildExecution(defaultContinueParentExecution);
                subProcessExecution.setCurrentFlowElement((FlowElement)subProcess);
                subProcessExecution.setScope(true);
                CommandContextUtil.getHistoryManager(commandContext).recordActivityStart(subProcessExecution);
                List boundaryEvents = subProcess.getBoundaryEvents();
                if (CollectionUtil.isNotEmpty((Collection)boundaryEvents)) {
                    this.executeBoundaryEvents(boundaryEvents, subProcessExecution);
                }
                ProcessInstanceHelper processInstanceHelper = CommandContextUtil.getProcessEngineConfiguration(commandContext).getProcessInstanceHelper();
                processInstanceHelper.processAvailableEventSubProcesses(subProcessExecution, (FlowElementsContainer)subProcess, commandContext);
                ExecutionEntity startSubProcessExecution = CommandContextUtil.getExecutionEntityManager(commandContext).createChildExecution(subProcessExecution);
                startSubProcessExecution.setCurrentFlowElement(startElement);
                moveExecutionContainer.addNewSubProcessChildExecution(subProcess.getId(), startSubProcessExecution);
            }
        }
        ArrayList<ExecutionEntity> arrayList = new ArrayList<ExecutionEntity>();
        for (FlowElement newFlowElement : moveToFlowElements) {
            ExecutionEntity newChildExecution = null;
            newChildExecution = moveExecutionContainer.getSubProcessesToCreateMap().containsKey(newFlowElement.getId()) ? moveExecutionContainer.getNewSubProcessChildExecution(moveExecutionContainer.getSubProcessesToCreateMap().get(newFlowElement.getId()).get(0).getId()) : executionEntityManager.createChildExecution(defaultContinueParentExecution);
            newChildExecution.setCurrentFlowElement(newFlowElement);
            if (newFlowElement instanceof CallActivity) {
                CommandContextUtil.getHistoryManager(commandContext).recordActivityStart(newChildExecution);
            }
            arrayList.add(newChildExecution);
        }
        return arrayList;
    }

    protected ExecutionEntity getActiveExecution(String activityId, ExecutionEntity processExecution, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExecutionEntity activeExecutionEntity = null;
        List<ExecutionEntity> childExecutions = executionEntityManager.findChildExecutionsByProcessInstanceId(processExecution.getId());
        for (ExecutionEntity childExecution : childExecutions) {
            if (!childExecution.getCurrentActivityId().equals(activityId)) continue;
            activeExecutionEntity = childExecution;
        }
        if (activeExecutionEntity == null) {
            throw new FlowableException("Active execution could not be found with activity id " + activityId);
        }
        return activeExecutionEntity;
    }

    protected ExecutionEntity deleteParentExecutions(String parentExecutionId, Collection<FlowElement> moveToFlowElements, CommandContext commandContext) {
        SubProcess parentSubProcess;
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExecutionEntity continueParentExecution = (ExecutionEntity)executionEntityManager.findById(parentExecutionId);
        if (continueParentExecution.getCurrentFlowElement() instanceof SubProcess && !this.isSubProcessUsedInNewFlowElements((parentSubProcess = (SubProcess)continueParentExecution.getCurrentFlowElement()).getId(), moveToFlowElements)) {
            ExecutionEntity toDeleteParentExecution = this.resolveParentExecutionToDelete(continueParentExecution, moveToFlowElements);
            ExecutionEntity finalDeleteExecution = null;
            finalDeleteExecution = toDeleteParentExecution != null ? toDeleteParentExecution : continueParentExecution;
            continueParentExecution = finalDeleteExecution.getParent();
            String flowElementIdsLine = this.printFlowElementIds(moveToFlowElements);
            executionEntityManager.deleteChildExecutions(finalDeleteExecution, "Change activity to " + flowElementIdsLine, true);
            executionEntityManager.deleteExecutionAndRelatedData(finalDeleteExecution, "Change activity to " + flowElementIdsLine);
        }
        return continueParentExecution;
    }

    protected void executeBoundaryEvents(Collection<BoundaryEvent> boundaryEvents, ExecutionEntity execution) {
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (CollectionUtil.isEmpty((Collection)boundaryEvent.getEventDefinitions()) || boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition) continue;
            ExecutionEntity childExecutionEntity = CommandContextUtil.getExecutionEntityManager().createChildExecution(execution);
            childExecutionEntity.setParentId(execution.getId());
            childExecutionEntity.setCurrentFlowElement((FlowElement)boundaryEvent);
            childExecutionEntity.setScope(false);
            ActivityBehavior boundaryEventBehavior = (ActivityBehavior)boundaryEvent.getBehavior();
            LOGGER.debug("Executing boundary event activityBehavior {} with execution {}", boundaryEventBehavior.getClass(), (Object)childExecutionEntity.getId());
            boundaryEventBehavior.execute(childExecutionEntity);
        }
    }

    protected ExecutionEntity createSubProcessInstance(CallActivity callActivity, ProcessDefinition subProcessDefinition, ExecutionEntity parentExecution, FlowElement initialFlowElement, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        Process subProcess = ProcessDefinitionUtil.getProcess(subProcessDefinition.getId());
        if (subProcess == null) {
            throw new FlowableException("Cannot start a sub process instance. Process model " + subProcessDefinition.getName() + " (id = " + subProcessDefinition.getId() + ") could not be found");
        }
        String businessKey = null;
        if (!StringUtils.isEmpty((CharSequence)callActivity.getBusinessKey())) {
            Expression expression = expressionManager.createExpression(callActivity.getBusinessKey());
            businessKey = expression.getValue((VariableContainer)parentExecution).toString();
        } else if (callActivity.isInheritBusinessKey()) {
            ExecutionEntity processInstance = (ExecutionEntity)executionEntityManager.findById(parentExecution.getProcessInstanceId());
            businessKey = processInstance.getBusinessKey();
        }
        ExecutionEntity subProcessInstance = executionEntityManager.createSubprocessInstance(subProcessDefinition, parentExecution, businessKey, initialFlowElement.getId());
        CommandContextUtil.getHistoryManager(commandContext).recordSubProcessInstanceStart(parentExecution, subProcessInstance);
        FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.PROCESS_CREATED, subProcessInstance));
        }
        subProcessInstance.setVariables(this.processDataObjects(subProcess.getDataObjects()));
        HashMap variables = new HashMap();
        if (callActivity.isInheritVariables()) {
            Map executionVariables = parentExecution.getVariables();
            for (Map.Entry entry : executionVariables.entrySet()) {
                variables.put(entry.getKey(), entry.getValue());
            }
        }
        for (IOParameter ioParameter : callActivity.getInParameters()) {
            Object value = null;
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getSourceExpression())) {
                Expression expression = expressionManager.createExpression(ioParameter.getSourceExpression().trim());
                value = expression.getValue((VariableContainer)parentExecution);
            } else {
                value = parentExecution.getVariable(ioParameter.getSource());
            }
            variables.put(ioParameter.getTarget(), value);
        }
        if (!variables.isEmpty()) {
            subProcessInstance.setVariables(variables);
        }
        if (eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_INITIALIZED, subProcessInstance));
        }
        ExecutionEntity subProcessInitialExecution = executionEntityManager.createChildExecution(subProcessInstance);
        subProcessInitialExecution.setCurrentFlowElement(initialFlowElement);
        CommandContextUtil.getHistoryManager(commandContext).recordActivityStart(subProcessInitialExecution);
        return subProcessInitialExecution;
    }

    protected void resolveSubProcesExecutionsToCreate(String searchActivitiyId, SubProcess searchSubProcess, List<ExecutionEntity> currentExecutions, MoveExecutionEntityContainer moveExecutionContainer) {
        if (searchSubProcess != null) {
            if (!this.hasSubProcessId(searchSubProcess.getId(), currentExecutions)) {
                moveExecutionContainer.addSubProcessToCreate(searchActivitiyId, searchSubProcess);
            }
            this.resolveSubProcesExecutionsToCreate(searchActivitiyId, searchSubProcess.getSubProcess(), currentExecutions, moveExecutionContainer);
        }
    }

    protected ExecutionEntity resolveParentExecutionToDelete(ExecutionEntity execution, Collection<FlowElement> moveToFlowElements) {
        ExecutionEntity parentExecution = execution.getParent();
        if (parentExecution.isProcessInstanceType()) {
            return null;
        }
        if (!this.isSubProcessUsedInNewFlowElements(parentExecution.getActivityId(), moveToFlowElements)) {
            ExecutionEntity subProcessParentExecution = this.resolveParentExecutionToDelete(parentExecution, moveToFlowElements);
            if (subProcessParentExecution != null) {
                return subProcessParentExecution;
            }
            return parentExecution;
        }
        return null;
    }

    protected boolean isSubProcessUsedInNewFlowElements(String subProcessId, Collection<FlowElement> moveToFlowElements) {
        boolean isUsed = false;
        for (FlowElement flowElement : moveToFlowElements) {
            SubProcess elementSubProcess = flowElement.getSubProcess();
            if (elementSubProcess == null || !elementSubProcess.getId().equals(subProcessId)) continue;
            isUsed = true;
            break;
        }
        return isUsed;
    }

    protected boolean hasSubProcessId(String subProcessId, List<ExecutionEntity> currentExecutions) {
        for (ExecutionEntity execution : currentExecutions) {
            FlowElement executionElement = execution.getCurrentFlowElement();
            if (executionElement.getSubProcess() == null) continue;
            while (executionElement.getSubProcess() != null) {
                if (executionElement.getSubProcess().getId().equals(subProcessId)) {
                    return true;
                }
                executionElement = executionElement.getSubProcess();
            }
        }
        return false;
    }

    protected FlowElement getStartElement(SubProcess subProcess) {
        if (CollectionUtil.isNotEmpty((Collection)subProcess.getFlowElements())) {
            for (FlowElement subElement : subProcess.getFlowElements()) {
                StartEvent startEvent;
                if (!(subElement instanceof StartEvent) || !CollectionUtil.isEmpty((Collection)(startEvent = (StartEvent)subElement).getEventDefinitions())) continue;
                return startEvent;
            }
        }
        return null;
    }

    protected Map<String, Object> processDataObjects(Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            variablesMap = new HashMap(dataObjects.size());
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }

    protected String printFlowElementIds(Collection<FlowElement> flowElements) {
        StringBuilder elementBuilder = new StringBuilder();
        for (FlowElement flowElement : flowElements) {
            if (elementBuilder.length() > 0) {
                elementBuilder.append(", ");
            }
            elementBuilder.append(flowElement.getId());
        }
        return elementBuilder.toString();
    }
}

