/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import org.flowable.engine.common.api.delegate.event.FlowableEngineEventType;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEventDispatcher;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.engine.common.impl.persistence.entity.EntityManager;
import org.flowable.engine.common.impl.persistence.entity.data.DataManager;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.AbstractManager;

public abstract class AbstractEntityManager<EntityImpl extends Entity>
extends AbstractManager
implements EntityManager<EntityImpl> {
    public AbstractEntityManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public EntityImpl findById(String entityId) {
        return (EntityImpl)this.getDataManager().findById(entityId);
    }

    public EntityImpl create() {
        return (EntityImpl)this.getDataManager().create();
    }

    public void insert(EntityImpl entity) {
        this.insert(entity, true);
    }

    public void insert(EntityImpl entity, boolean fireCreateEvent) {
        this.getDataManager().insert(entity);
        if (fireCreateEvent) {
            this.fireEntityInsertedEvent((Entity)entity);
        }
    }

    protected void fireEntityInsertedEvent(Entity entity) {
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, entity));
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_INITIALIZED, entity));
        }
    }

    public EntityImpl update(EntityImpl entity) {
        return this.update(entity, true);
    }

    public EntityImpl update(EntityImpl entity, boolean fireUpdateEvent) {
        Entity updatedEntity = this.getDataManager().update(entity);
        if (fireUpdateEvent) {
            this.fireEntityUpdatedEvent((Entity)entity);
        }
        return (EntityImpl)updatedEntity;
    }

    protected void fireEntityUpdatedEvent(Entity entity) {
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_UPDATED, entity));
        }
    }

    public void delete(String id) {
        EntityImpl entity = this.findById(id);
        this.delete(entity);
    }

    public void delete(EntityImpl entity) {
        this.delete(entity, true);
    }

    public void delete(EntityImpl entity, boolean fireDeleteEvent) {
        this.getDataManager().delete(entity);
        if (fireDeleteEvent && this.getEventDispatcher().isEnabled()) {
            this.fireEntityDeletedEvent((Entity)entity);
        }
    }

    protected void fireEntityDeletedEvent(Entity entity) {
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, entity));
        }
    }

    protected abstract DataManager<EntityImpl> getDataManager();
}

