/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.test;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.flowable.form.api.FormManagementService;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.flowable.form.engine.FormEngine;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.test.FlowableFormTestHelper;
import org.flowable.form.engine.test.FormConfigurationResource;
import org.flowable.form.engine.test.FormDeploymentAnnotation;
import org.flowable.form.engine.test.FormDeploymentId;
import org.flowable.form.engine.test.FormTestHelper;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowableFormExtension
implements ParameterResolver,
BeforeEachCallback,
AfterEachCallback {
    public static final String DEFAULT_CONFIGURATION_RESOURCE = "flowable.form.cfg.xml";
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{FlowableFormExtension.class});
    private static final Set<Class<?>> SUPPORTED_PARAMETERS = new HashSet<Class>(Arrays.asList(FormEngineConfiguration.class, FormEngine.class, FormRepositoryService.class, FormManagementService.class, FormService.class));
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String configurationResource;

    public FlowableFormExtension() {
        this(DEFAULT_CONFIGURATION_RESOURCE);
    }

    public FlowableFormExtension(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public void beforeEach(ExtensionContext context) {
        AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), FormDeploymentAnnotation.class).ifPresent(deployment -> {
            FlowableFormTestHelper testHelper = this.getTestHelper(context);
            String deploymentIdFromDeploymentAnnotation = FormTestHelper.annotationDeploymentSetUp(testHelper.getFormEngine(), context.getRequiredTestClass(), context.getRequiredTestMethod(), deployment);
            testHelper.setDeploymentIdFromDeploymentAnnotation(deploymentIdFromDeploymentAnnotation);
        });
    }

    public void afterEach(ExtensionContext context) {
        FlowableFormTestHelper flowableTestHelper = this.getTestHelper(context);
        FormEngine formEngine = flowableTestHelper.getFormEngine();
        String deploymentIdFromDeploymentAnnotation = flowableTestHelper.getDeploymentIdFromDeploymentAnnotation();
        if (deploymentIdFromDeploymentAnnotation != null) {
            FormTestHelper.annotationDeploymentTearDown(formEngine, deploymentIdFromDeploymentAnnotation, context.getRequiredTestClass(), context.getRequiredTestMethod().getName());
            flowableTestHelper.setDeploymentIdFromDeploymentAnnotation(null);
        }
        formEngine.getFormEngineConfiguration().getClock().reset();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext context) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return SUPPORTED_PARAMETERS.contains(parameterType) || FlowableFormTestHelper.class.equals(parameterType) || parameterContext.isAnnotated(FormDeploymentId.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) {
        FormEngine formEngine;
        FlowableFormTestHelper flowableTestHelper = this.getTestHelper(context);
        if (parameterContext.isAnnotated(FormDeploymentId.class)) {
            return flowableTestHelper.getDeploymentIdFromDeploymentAnnotation();
        }
        Class<?> parameterType = parameterContext.getParameter().getType();
        if (parameterType.isInstance(formEngine = flowableTestHelper.getFormEngine())) {
            return formEngine;
        }
        if (FlowableFormTestHelper.class.equals(parameterType)) {
            return flowableTestHelper;
        }
        try {
            return FormEngine.class.getDeclaredMethod("get" + parameterType.getSimpleName(), new Class[0]).invoke((Object)formEngine, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ParameterResolutionException("Could not find service " + parameterType, (Throwable)ex);
        }
    }

    protected String getConfigurationResource(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getTestClass(), FormConfigurationResource.class).map(FormConfigurationResource::value).orElse(DEFAULT_CONFIGURATION_RESOURCE);
    }

    protected FlowableFormTestHelper getTestHelper(ExtensionContext context) {
        return (FlowableFormTestHelper)this.getStore(context).getOrComputeIfAbsent((Object)context.getRequiredTestClass(), key -> new FlowableFormTestHelper(this.createFormEngine(context)), FlowableFormTestHelper.class);
    }

    protected FormEngine createFormEngine(ExtensionContext context) {
        return FormTestHelper.getFormEngine(this.getConfigurationResource(context));
    }

    protected ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }
}

