/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import java.math.BigInteger;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;

public class BigIntegerType
implements VariableType {
    public static final String TYPE_NAME = "biginteger";

    public String getTypeName() {
        return TYPE_NAME;
    }

    public boolean isCachable() {
        return true;
    }

    public Object getValue(ValueFields valueFields) {
        BigInteger bigInteger = null;
        String textValue = valueFields.getTextValue();
        if (textValue != null && !textValue.isEmpty()) {
            bigInteger = new BigInteger(textValue);
        }
        return bigInteger;
    }

    public void setValue(Object value, ValueFields valueFields) {
        if (value != null) {
            valueFields.setTextValue(value.toString());
        } else {
            valueFields.setTextValue(null);
        }
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return BigInteger.class.isAssignableFrom(value.getClass());
    }
}

